﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : MainEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient un accès au serveur pour la transmission au front et
 * un accès au debug pour afficher la gesture.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;
using Trakers.Debug;

namespace Trakers.MainModule.Events
{
    public class MainEventArgs : EventArgs
    {
        public readonly Server server;
        public readonly DebugWindow debug;

        public MainEventArgs(Server _server, DebugWindow _debug) : base()
        {
            server = _server;
            debug = _debug;
        }
    }
}
