﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : CrossListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a croisé les bras en X.
 * Il contient le code a être éxecuté au cas où cet événement survient.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.MainModule.Events
{
    public class CrossListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a croisé les bras en X.
        */
        public void showAndSend(object o, CrossEventArgs e)
        {
            e.debug.showGesture("CROSS");
            e.server.GesturePerformed("CROSS");
        }
    }
}
