﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Postures
 * Classe : CrossDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur a croisé les bras en X, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Postures
{
    public class CrossDetector : PostureDetector
    {
        public CrossDetector(DebugWindow _debug) : base(_debug)
        {
        }

        /*
         * Méthode de détection du penché.
         */
        public bool CheckForCross()
        {
            //Crée un état local afin de pouvoir analyser s'il y a une posture.
            List<Joint> localState = new List<Joint>(currentState);

            //La distance de référence est ici la distance entre le milieu du dos et le milieu des épaules.
            refDistance = Math.Abs(localState[(int)JointType.Spine].Position.Y - localState[(int)JointType.ShoulderCenter].Position.Y);

            /*if (localState[(int)JointType.HandLeft].Position.Y < localState[(int)JointType.ElbowLeft].Position.Y - refDistance / 2)
                debug.onR0(true);
            else
                debug.onR0(false);
            if (localState[(int)JointType.HandRight].Position.Y < localState[(int)JointType.ElbowRight].Position.Y - refDistance / 2)
                debug.onR1(true);
            else
                debug.onR1(false);
            if (localState[(int)JointType.ElbowLeft].Position.X + refDistance / 2 < localState[(int)JointType.ElbowRight].Position.X)
                debug.onR2(true);
            else
                debug.onR2(false);
            if (localState[(int)JointType.HandLeft].Position.X + refDistance / 2 > localState[(int)JointType.HandRight].Position.X)
                debug.onR3(true);
            else
                debug.onR3(false);*/
            //Si la position Y de la main gauche n'est pas plus haute de la distance de référence que le coude gauche
            //OU si la position Y de la main droite n'est pas plus haute de la distance de référence que le coude droit
            //OU si la position X du coude gauche n'est pas plus à gauche de la distance de référence/2 que le coude droit
            //OU si la position X de la main gauche n'est pas plus à droite de la distance de référence/4 que la main gauche.
            //Alors l'utilisateur ne croise pas les bras.
            /*if (localState[(int)JointType.HandRight].Position.Y > localState[(int)JointType.ElbowRight].Position.Y + refDistance ||
            localState[(int)JointType.HandRight].Position.Y > localState[(int)JointType.HipCenter].Position.Y ||
            localState[(int)JointType.HandRight].Position.Y > localState[(int)JointType.WristRight].Position.Y + refDistance / 4)
                return false;
            return true;*/

            return false;
        }
    }
}