﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;

namespace Trakers.Tracking.Gestures
{
    public class SwipeDetector : GestureDetector
    {
        public enum Direction {LEFT, RIGHT, TOP, DOWN};

        public SwipeDetector() : base()
        {
            gesturePeriod = (float)0.5;
            indexesPerSecond = 30;
            indexesToCheck = (int)(gesturePeriod * indexesPerSecond);
        }

        /*
         * Lit les noeuds de l'historique du squelette afin de détecter un Swipe left.
         * Règles :
         * Se fait avec la main droite.
         * Chaque nouvelle position de la main doit être à la gauche de la précédente.
         * Chaque nouvelle position de la main ne doit pas s'éloigner verticalement de plus d'une certaine distance.
         * Le geste doit mesurer horizontalement une certaine distance.
         */
        public bool CheckForSwipeLeft()
        {
            //Crée un historique de squelette local, puisque l'historique est mis à jour toutes les ~1/30 s.
            //List<Skeleton> history = new List<Skeleton>(history);

            /*for (int i = 0; i < history.Count; i++)
                System.Console.Out.WriteLine(history[i].Joints.ElementAt(handRightID).Position.X);
            System.Console.Out.WriteLine("========================");*/

            //Si il n'y a pas assez de positions dans l'historique local pour vérifier le geste.
            if (history.Count < indexesToCheck+1)
                return false;
            //Console.ReadLine();

            //La distance de référence est ici la distance entre le milieu du dos et le milieu des épaules.
            refDistance = Math.Abs(history[0][spineID].Position.Y - history[0][shoulderCenterID].Position.Y);
            //On commence la position pour les indexesToCheck dernières postures (celle à l'index 0 étant la dernière).
            startPoint = history[history.Count - indexesToCheck][handRightID].Position;

            //De la position p1 à pn, on suit l'algorithme.
            Console.Out.WriteLine("=================================");
            for (int i = history.Count - indexesToCheck + 1; i < history.Count; i++)
            {
                System.Console.Out.WriteLine("hand:head " + history[i][handRightID].Position.Y + " <= " + history[i][headID].Position.Y + " && "
                + "hand:hip " + history[i][handRightID].Position.Y + " >= " + history[i][hipCenterID].Position.Y + " && "
                + "handX:handX-1 " + history[i][handRightID].Position.X + " <= " + history[i - 1][handRightID].Position.X + " && "
                + "hand0:handN " + Math.Abs(history[i][handRightID].Position.Y - startPoint.Y) + " <= " + refDistance / 2);

                //Si la position Y de la main est supérieure à celle de l'épaule
                //OU si la position Y de la main est inférieure à celle de la hanche
                //OU si la nouvelle position X de la main est à droite de la précédente
                //OU si la nouvelle position Y de la main est plus éloignée de la distance N par rapport à la première position Y
                //Alors on retourne faux.
                if (history[i][handRightID].Position.Y > history[i][headID].Position.Y ||
                history[i][handRightID].Position.Y < history[i][hipCenterID].Position.Y ||
                history[i][handRightID].Position.X > history[i - 1][handRightID].Position.X ||
                Math.Abs(history[i][handRightID].Position.Y - startPoint.Y) > refDistance/2)
                    return false;
            }
            Console.Out.WriteLine("=================================");
            Console.ReadLine();
            //Si la distance horizontale du geste a été plus courte que la distance N
            //Alors on retourne faux.
            float dist = (history[history.Count - 1][handRightID].Position.X - history[history.Count - indexesToCheck][handRightID].Position.X);
            
            //System.Console.Out.WriteLine(history[0].Joints.ElementAt(handRightID).Position.X + " " + history[1].Joints.ElementAt(handRightID).Position.X + " " + history[2].Joints.ElementAt(handRightID).Position.X);
            //System.Console.Out.WriteLine(history[0].Joints.ElementAt(handRightID).Position.X + " " + history[1].Joints.ElementAt(handRightID).Position.X + " " + history[2].Joints.ElementAt(handRightID).Position.X);
            System.Console.Out.WriteLine(Math.Abs(history[0][handRightID].Position.X - history[history.Count - indexesToCheck][handRightID].Position.X) + " < " + refDistance*1.5);
            if (Math.Abs(history[0][handRightID].Position.X - history[history.Count - indexesToCheck][handRightID].Position.X) < refDistance*1.5)
                return false;

            history.Clear();
            Console.Out.WriteLine("SWIPE LEF");
            Console.ReadLine();
            return true;
        }
    }
}
