﻿/*
 * Projet : KINECT PROJECTS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking
 * Classe : LeftHandTrackedEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : La main gauche est entrée dans le champ.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Communication;

namespace Trakers.Tracking.Events
{
    public class LeftHandTrackedEventArgs : EventArgs
    {
        public readonly Joint handJoint;
        public readonly float position;
        public readonly Debug.DebugWindow debug;
        public readonly Server server;

        /*
        * Constructeur : Il prend le noeud de la main, sa position, l'affichage de debug et le serveur TUIO.
        */
        public LeftHandTrackedEventArgs(Joint joint, float pos, Debug.DebugWindow _debug, Server _server)
        {
            handJoint = joint;
            position = pos;
            debug = _debug;
            server = _server;
        }
    }
}
