/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.util.Enumeration;
import java.util.Vector;

public class OSCMessage
extends OSCPacket {
    protected String address;
    protected Vector<Object> arguments;

    public OSCMessage() {
        this.arguments = new Vector();
    }

    public OSCMessage(String string) {
        this(string, null);
    }

    public OSCMessage(String string, Object[] objectArray) {
        this.address = string;
        if (null != objectArray) {
            this.arguments = new Vector(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                this.arguments.add(objectArray[i]);
            }
        } else {
            this.arguments = new Vector();
        }
        this.init();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void addArgument(Object object) {
        this.arguments.add(object);
    }

    public Object[] getArguments() {
        return this.arguments.toArray();
    }

    protected void computeAddressByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        oSCJavaToByteArrayConverter.write(this.address);
    }

    protected void computeArgumentsByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        oSCJavaToByteArrayConverter.write(',');
        if (null == this.arguments) {
            return;
        }
        oSCJavaToByteArrayConverter.writeTypes(this.arguments);
        Enumeration<Object> enumeration = this.arguments.elements();
        while (enumeration.hasMoreElements()) {
            oSCJavaToByteArrayConverter.write(enumeration.nextElement());
        }
    }

    protected void computeByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        this.computeAddressByteArray(oSCJavaToByteArrayConverter);
        this.computeArgumentsByteArray(oSCJavaToByteArrayConverter);
        this.byteArray = oSCJavaToByteArrayConverter.toByteArray();
    }
}

