﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : KeepUpListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a levé le genou.
 * Il contient le code a être éxecuté au cas où cet événement survient.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.MainModule.Events
{
    public class KneeUpListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a levé le genou.
        */
        public void showAndSend(object o, KneeUpEventArgs e)
        {
            e.debug.showGesture("KNEE-UP");
            e.server.GesturePerformed("KNEE-UP");
        }
    }
}
