﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : SwipeEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur a effectué un swipe.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Tracking.Gestures;
using Trakers.Debug;
using Trakers.Communication;

namespace Trakers.MainModule.Events
{
    public class SwipeEventArgs : MainEventArgs
    {
        //Direction du swipe.
        public readonly SwipeDetector.Direction direction;

        /*
        * Constructeur : Il prend la direction du swipe.
        */
        public SwipeEventArgs(Server _server, DebugWindow _debug, SwipeDetector.Direction _direction) : base(_server, _debug)
        {
            direction = _direction;
        }
    }
}
