﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : RightHandTrackedEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : La main droite est entrée dans le champ.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;
using Trakers.Communication;

namespace Trakers.MainModule.Events
{
    public class RightHandTrackedEventArgs : MainEventArgs
    {
        public readonly Joint handJoint;
        public readonly float position;

        /*
        * Constructeur : Il prend le noeud de la main et sa position.
        */
        public RightHandTrackedEventArgs(Server _server, DebugWindow _debug, Joint joint, float pos) : base(_server, _debug)
        {
            handJoint = joint;
            position = pos;
        }
    }
}
