﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Debug
 * Classe : DebugParameters
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Code source attaché à la fenêtre de paramétrage du Middleware.
 * Celui-ci permet de charger/sauvegarder les paramètres stockés dans KinectMain.
 */

using System;
using System.Reflection;
using System.Resources;
using System.Windows;
using System.Windows.Controls;

namespace Trakers.Debug
{
    /// <summary>
    /// Interaction logic for DebugParameters.xaml
    /// </summary>
    public partial class DebugParameters : Window
    {
        private ResourceManager rm;
        private DebugWindow debug;

        /*
         * Constructeur : On ouvre la fenêtre et on charge les paramètres.
         */
        public DebugParameters(DebugWindow _debug)
        {
            rm = new ResourceManager("Trakers.Debug.Properties.Resources", Assembly.GetExecutingAssembly());
            debug = _debug;
            InitializeComponent();
            getParameters();
        }

        /*
         * Permet de charger les paramètres depuis KinectMain et les affiche dans la fenêtre de paramétrage.
         */
        public void getParameters()
        {
            searchMinDistanceTB.Text = debug.getMinDistHands().ToString();
            searchMaxDistanceTB.Text = debug.getMaxDistHands().ToString();
            minDistanceTB.Text = debug.getMinDist().ToString();
            maxDistanceTB.Text = debug.getMaxDist().ToString();
            zeroPointTB.Text = debug.getZeroPoint().ToString();
            connexionHostTB.Text = debug.getConnexionHost();
            connexionPortTB.Text = debug.getConnexionPort().ToString();
            timerElapsingTB.Text = debug.getTimerElapsing().ToString();
            imagesToShowTB.Text = debug.getImagesToShow().ToString();
            takenPointsTB.Text = debug.getTakenPoints().ToString();
            directionChangeTresholdXYTB.Text = debug.getTakenPoints().ToString();
            directionChangeTresholdZTB.Text = debug.getTakenPoints().ToString();
        }

        /*
         * Permet de sauvegarder les paramètres de la fenêtre de paramétrage vers KinectMain.
         */
        public void setParameters()
        {
            try
            {
                ExceptionInParametersLbl.Content = "";

                float minDistHands = float.Parse(searchMinDistanceTB.Text);
                float maxDistHands = float.Parse(searchMaxDistanceTB.Text);
                float minDist = float.Parse(minDistanceTB.Text);
                float maxDist = float.Parse(maxDistanceTB.Text);
                float zeroPoint = float.Parse(zeroPointTB.Text);
                int connexionPort = int.Parse(connexionPortTB.Text);
                int timerElapsing = int.Parse(timerElapsingTB.Text);
                int imagesToShow = int.Parse(imagesToShowTB.Text);
                int takenPoints = int.Parse(takenPointsTB.Text);
                int directionChangeTresholdXY = int.Parse(directionChangeTresholdXYTB.Text);
                float directionChangeTresholdZ = float.Parse(directionChangeTresholdZTB.Text);

                if (maxDistHands <= 0f || minDistHands <= 0f || maxDistHands > maxDist || minDistHands > maxDist ||
                minDistHands >= maxDistHands || zeroPoint < maxDistHands || minDistHands > minDist ||
                zeroPoint >= maxDist || connexionPort < 0 || timerElapsing < 0 || imagesToShow < 1 ||
                takenPoints <= 0 || directionChangeTresholdXY < 0 || directionChangeTresholdZ < 0)
                {
                    ExceptionInParametersLbl.Content = rm.GetString("loadParametersIncorrect");
                }
                else
                {
                    debug.setMinDistHands(minDistHands);
                    debug.setMaxDistHands(maxDistHands);
                    debug.setMinDist(minDist);
                    debug.setMaxDist(maxDist);
                    debug.setZeroPoint(zeroPoint);
                    debug.setConnexionHost(connexionHostTB.Text);
                    debug.setConnexionPort(connexionPort);
                    debug.setTimerElapsing(timerElapsing);
                    debug.setImagesToShow(imagesToShow);
                    debug.setTakenPoints(takenPoints);
                    debug.setDirectionChangeTresholdXY(directionChangeTresholdXY);
                    debug.setDirectionChangeTresholdZ(directionChangeTresholdZ);

                    debug.updateParameters();
                    ExceptionInParametersLbl.Content = null;
                }
            }
            catch (Exception)
            {
                //S'il y a eu un problème de parsing (i.e si l'utilisateur a entré une mauvaise valeur),
                //Alors on affiche l'erreur, puis on recharge les paramètres précédents.
                ExceptionInParametersLbl.Content = rm.GetString("loadParametersFail");
                getParameters();
            }
        }

        /*
         * Méthode attachée à l'événement click sur le bouton de validation de la fenêtre de paramétrage.
         * Les données sont sauvegardées vers KinectMain, puis rechargées dans la fenêtre.
         */
        private void Button_Click(object sender, RoutedEventArgs e)
        {
            setParameters();
        }

        /*
         * Getters et Setters.
         */
        public void setModButton(Button button)
        {
            ModButton = button;
        }

        public Button getModButton()
        {
            return ModButton;
        }

        /*
         * S'effectue lorsque la fenêtre se ferme.
         */
        private void Window_Closed(object sender, EventArgs e)
        {

        }
    }
}
