﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : UserPositionEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur se déplace dans la zone de détection.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;
using Trakers.Debug;

namespace Trakers.MainModule.Events
{
    public class UserPositionEventArgs : MainEventArgs
    {
        //Distance à Kinect.
        public readonly float distance;
        //Nombre d'images à afficher.
        public readonly int imagesToShow;

        /*
        * Constructeur : Il prend la distance à Kinect.
        */
        public UserPositionEventArgs(Server _server, DebugWindow _debug, float _distance, int _imagesToShow) : base(_server, _debug)
        {
            distance = _distance;
            imagesToShow = _imagesToShow;
        }
    }
}
