/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

class particle
{
  float x;
  float y;
  float xvel;
  float yvel;
  float temp;
  int pos;
  
  particle(float xIn, float yIn) {
    x = xIn;
    y = yIn;
  }

  void reposition() {
    x = WIDTH/2+random(-20,20);
    y = random(HEIGHT-10,HEIGHT);
  
    xvel = random(-1,1);
    yvel = random(-1,1);
  }

  void updatepos() {
    int vi = (int)(x/RES);
    int vu = (int)(y/RES);

    if(vi > 0 && vi < lwidth && vu > 0 && vu < lheight) {
      v[vi][vu].addcolour(2);

      float ax = (x%RES)/RES;
      float ay = (y%RES)/RES;
  
      xvel += (1-ax)*v[vi][vu].xvel*0.05;
      yvel += (1-ay)*v[vi][vu].yvel*0.05;
      
      xvel += ax*v[vi+1][vu].xvel*0.05;
      yvel += ax*v[vi+1][vu].yvel*0.05;
      
      xvel += ay*v[vi][vu+1].xvel*0.05;
      yvel += ay*v[vi][vu+1].yvel*0.05;
      
      v[vi][vu].yvel -= (1-ay)*0.003;
      v[vi+1][vu].yvel -= ax*0.003;
      //v[vi][vu+1].yvel -= ay*0.003;
      
      if(v[vi][vu].yvel < 0) v[vi][vu].yvel *= 1.00025;
      
      x += xvel;
      y += yvel;
    }
    else {
      reposition();
    }
    if(random(0,400) < 1) reposition();
    
    xvel *= 0.6;
    yvel *= 0.6;
  }
}
