/*
* This file is part of the TraKERS\Front JS package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front JS
 * Fichier : gestures.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" de gestion des gestes et définit des fonctions d'intéraction.
 */

/*
 * Classe définissant les gestes.
 */
function Gestures(config)
{
    this.isGestureShown = false;
    this.showGestureTimeout;
    
    this.imgWidth;
    this.imgHeight;
    
    this.config = config;

    var textPanel = "<div id='textPanel'>Aucune gesture n'est détectée.</div>";
    var imagePanel = "<img id='imagePanel' src='./img/black.png'></img>";
    $('body').append(textPanel + imagePanel);
    
	this.help();
	
    $('#imagePanel').load(function()
    {
        this.imgWidth = $('#imagePanel').width();
        this.imgHeight = $('#imagePanel').height();
        
        //On positionne l'image au centre de l'écran.
        $('#imagePanel').css(
        {
            top: ($(window).height() - $('#help').position().top) / 2,
            left: ($(window).width() - this.imgHeight) / 2
        });
		
		$('#help').css(
		{
			position: 'absolute',
			width: '100%',
			top: $(window).height() - $('#help').height()
		});
    });
    
    this.wsClient = new Client(this.config.host, this.config.port, this);
	
}

/*
 * Affiche les gestures reçues.
*/
Gestures.prototype.showGesture = function(gesture)
{
    //Si on n'avait aucune gesture, on peut l'afficher.
    if(!this.isGestureShown)
    {
        var _this = this;
        
        this.isGestureShown = true;
        $('#textPanel').html("Gesture de code " + gesture + " détectée.");
        //On retrouve le nom du fichier image correspondant dans le code de la gesture.
        gesture = gesture.toLowerCase().replace('-', '_');
        $('#imagePanel').attr("src", "./img/" + gesture + ".png");
        
        //On supprime l'affichage au bout de N ms.
        this.showGestureTimeout = setTimeout(function()
        {
            _this.isGestureShown = false;
            $('#imagePanel').attr("src", "./img/black.png");
            $('#textPanel').html("Aucune gesture n'est détectée.");
        }, this.config.timeShowGesture);
    }
}

/*
 * Affiche les gestes affichables.
*/
Gestures.prototype.help = function()
{
	//On crée le texte et les images à mettre en bas de la fenêtre pour guider l'utilisateur.
	var imgs = ['bend', 'fall', 'hello', 'jump', 'knee_up', 'pull_both', 'pull_right', 'pull_left', 'push_both', 'push_left', 'push_right', 'swipe_left', 'swipe_right'];
	var helpText = '<div id="helpText">Gestures détectables :</div>';
	var helpImgs = '<div id="helpImgs">';
	for(var i = 0 ; i < imgs.length ; i++)
	{
		helpImgs += '<img class="help_imgs" id="img_' + imgs[i] + '" src="./img/' + imgs[i] + '.png" />';
	}
	helpImgs += '</div>';
	var help = '<div id="help">' + helpText + helpImgs + '</div>'
	
	$('body').append(help);
	
	console.log($(window).height() + ' ' + $('#help').height());
}