﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Postures
 * Classe : KneeUpDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur a levé le genou, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Postures
{
    public class KneeUpDetector : PostureDetector
    {
        public KneeUpDetector(DebugWindow _debug) : base(_debug)
        {
        }

        /*
         * Méthode de détection du penché.
         */
        public bool CheckForKneeUp()
        {
            //Crée un état local afin de pouvoir analyser s'il y a une posture.
            List<Joint> localState = new List<Joint>(currentState);

            //La distance de référence est ici la distance entre le milieu du dos et le milieu des épaules.
            float refDistance = Math.Abs(localState[(int)JointType.Spine].Position.Y - localState[(int)JointType.ShoulderCenter].Position.Y);

            /*if (Math.Abs(localState[(int)JointType.KneeLeft].Position.Y - localState[(int)JointType.KneeRight].Position.Y) > refDistance / 2)
                debug.onR0(true);
            else
                debug.onR0(false);
            if (Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeLeft].Position.Z) > 0.20)
                debug.onR1(true);
            else
                debug.onR1(false);
            if (Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeRight].Position.Z) > 0.20)
                debug.onR2(true);
            else
                debug.onR2(false);*/

            //Si un genou n'est pas plus haut de la distance de référence/2 que l'autre
            //OU si le genou gauche n'est pas plus proche de 20cm par rapport à la hanche
            //OU si le genou droit n'est pas plus proche de 20cm par rapport à la hanche.
            //Alors on n'a pas levé de genou.
            if (Math.Abs(localState[(int)JointType.KneeLeft].Position.Y - localState[(int)JointType.KneeRight].Position.Y) < refDistance / 2 ||
            Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeLeft].Position.Z) < 0.20 &&
            Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.KneeRight].Position.Z) < 0.20)
                return false;
            return true;
        }
    }
}
