﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : RightHandQuitEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : La main droite est sortie du champ.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Communication;

namespace Trakers.Tracking.Events
{
    public class RightHandQuitEventArgs : EventArgs
    {
        public readonly Debug.DebugWindow debug;
        public readonly Server server;

        /*
        * Constructeur : Il prend l'affichage de debug et le serveur TUIO.
        */
        public RightHandQuitEventArgs(Debug.DebugWindow _debug, Server _server)
        {
            debug = _debug;
            server = _server;
        }
    }
}
