/*
 * Un client est défini par une socket, qui permettra de recevoir les données du server websocket du Middleware.
 * On accède aussi à la mosaïque.
*/
function client(host, port, _mosaic)
{
	this.socket;
	this.mosaic = _mosaic;
	
	this.pointerLeft = false;
	this.pointerRight = false;
	this.timePointers = 100;
	this.pointerLeftTimeout;
	this.pointerRightTimeout;
	this.isLeftHanded = false;
	
	this.createWebSocket('ws://' + host + ':' + port + '/');
}

/*
 * Création et Initialisation des sockets et listeners permettant d'écouter le server.
*/
client.prototype.createWebSocket = function(host)
{
	var _this = this;
	
	//Initialise la fonctionnalité websocket du naviguateur.
    if(window.MozWebSocket)
	{
        window.WebSocket = window.MozWebSocket;
	}
	
	//Si le naviguateur ne supporte pas les websockets, on s'arrête là.
    if(!window.WebSocket)
	{
        alert('Votre navigateur ne supporte pas les webSocket!');
        return false;
    }
	//Sinon
	else
	{
		//On initialise la socket.
		this.socket = new WebSocket(host);
		
		//Si elle est ouverte, on notifie le Front.
		this.socket.onopen = function()
		{
			console.log('Socket ouverte.');
		}
		//Si elle est fermée, on notifie le Front.
		this.socket.onclose = function()
		{
			console.log('Socket fermée.');
		}
		//S'il y a un problème dans la connection, on notifie le Front.
		this.socket.onerror = function()
		{
			console.log('Une erreur est survenue dans le module de Communication.');
		}
		//Si on reçoit un message.
		this.socket.onmessage = function(msg)
		{
			_this.processMsg(msg);
		}
    }
}

/*
 * Traite un message reçu du Middleware.
*/
client.prototype.processMsg = function(msg)
{
	if(typeof msg === 'undefined' || typeof msg.data === 'undefined')
	{
		return;
	}
	
	var _this = this;
	
	
	//S'il s'agit d'une string et non d'une instruction pour les pointeurs.
	if(msg.data[0] === '2')
	{
		var instruction = msg.data.substring(2, msg.data.length);
		
		// if(instruction.indexOf("INCOMING") == -1 && instruction.indexOf('NO-USER') == -1)
		// {
			this.mosaic.manageControlEvents(instruction);
		// }
	}
	//Sinon si ce sont les coordonnées de la main droite.
	// /!\/!\ //
	else if(msg.data[0] == '1')
	{
		var instruction = msg.data.substring(2, msg.data.length);
		pt = instruction.split(';');
		var x = Math.abs(parseFloat(pt[0])), y = Math.abs(parseFloat(pt[1]));
		// console.log(Math.abs(parseFloat(pt[0])), Math.abs(parseFloat(pt[1])));
		
		this.pointerLeft = true;
		clearTimeout(this.pointerLeftTimeout);
		
		if(!this.mosaic.mouseInteractions && this.mosaic.currentMode != 'NO-USER' && this.mosaic.currentMode.indexOf('INCOMING') == -1)
		{
			// console.log('pt');
			this.mosaic.refreshMainPointer(x, y);
		}
		
		// /!\ //
		if(!this.mosaic.isMainPointerDisplayed)
		{
			this.mosaic.mainPointerDisplay(true);
			this.mosaic.isMainPointerDisplayed = true;
		}
		
		this.pointerLeftTimeout = setTimeout(function()
		{
			// console.log('RELEASE LEFT');
			_this.pointerLeft = false;
			
			if(_this.mosaic.isMainPointerDisplayed)
			{
				_this.mosaic.isMainPointerDisplayed = false;
				_this.mosaic.mainPointerDisplay(false);
			}
		}, this.timePointers);
	}
	//Sinon si ce sont les coordonnées de la main gauche.
	else if(msg.data[0] == '0')
	{
		var instruction = msg.data.substring(2, msg.data.length);
		pt = instruction.split(';');
		var x = Math.abs(parseFloat(pt[0])), y = Math.abs(parseFloat(pt[1]));
		// console.log(Math.abs(parseFloat(pt[0])), Math.abs(parseFloat(pt[1])));
		
		this.pointerRight = true;
		clearTimeout(this.pointerRightTimeout);
		
		if(!this.mosaic.mouseInteractions && this.mosaic.currentMode != 'NO-USER' && this.mosaic.currentMode.indexOf('INCOMING') == -1)
		{
			this.mosaic.refreshSecondPointer(x, y);
		}
		
		if(!this.mosaic.isSecondPointerDisplayed)
		{
			this.mosaic.secondPointerDisplay(true);
			this.mosaic.isSecondPointerDisplayed = true;
		}
		
		this.pointerRightTimeout = setTimeout(function()
		{
			// console.log('RELEASE RIGHT');
			_this.pointerRight = false;
			
			if(_this.mosaic.isSecondPointerDisplayed)
			{
				_this.mosaic.isSecondPointerDisplayed = false;
				_this.mosaic.secondPointerDisplay(false);
			}
		}, this.timePointers);
	}
	
	if(this.pointerLeft && !this.pointerRight || !this.pointerLeft && this.pointerRight)
	{
		//On interrompt l'idle des pointeurs.
		this.mosaic.pointersIdleAvailable = false;
		this.mosaic.removeIdlePointers();
		this.mosaic.areBothPointersHere = false;
		
		if(this.mosaic.isSearchByCurvesOn)
		{
			this.mosaic.isSearchByCurvesOn = false;
			if(this.mosaic.searchCanvas)
			{
				this.mosaic.searchCanvas.onPointerOut();
				console.log('OUT !!!!!');
			}
		}
	}
	if(!this.pointerLeft && !this.pointerRight)
	{
		//On interrompt l'idle des pointeurs.
		this.mosaic.pointersIdleAvailable = false;
		this.mosaic.removeIdlePointers();
		this.mosaic.areBothPointersHere = false;
		
		if(this.mosaic.isSearchByCurvesOn)
		{
			this.mosaic.isSearchByCurvesOn = false;
			if(this.mosaic.searchCanvas)
			{
				this.mosaic.searchCanvas.onPointerOut();
			}
		}
		
		this.mosaic.deselectAllNeighbours();
		this.mosaic.preUnzoom();
	}
	
	if(this.pointerLeft && this.pointerRight)
	{
		this.mosaic.areBothPointersHere = true;
		this.mosaic.removeCheckForBothPointersHere();
		
		if(this.mosaic.currentMode == 'MOSAIC' || this.mosaic.currentMode == 'FILTER')
		{
			$('#mainPointer').css('background-image', './img/cursors/pointer.png');
			$('#secondPointer').css('background-image', './img/cursors/pointer2.png');
		}
		
		if(this.mosaic.currentMode == 'FILTER' || this.mosaic.currentMode == 'SEARCH')
		{
			if(this.mosaic.searchCanvas)
			{
				var mainPointerX = +$('#mainPointer').position().left + $('#mainPointer').width() / 2;
				var mainPointerY = +$('#mainPointer').position().top - this.mosaic.MPTop_margin + $('#mainPointer').height() / 2;
				var secondPointerX = +$('#secondPointer').position().left + $('#mainPointer').width() / 2;
				var secondPointerY = +$('#secondPointer').position().top - this.mosaic.MPTop_margin + $('#mainPointer').height() / 2;
				
				if(!this.mosaic.isSearchByCurvesOn)
				{
					this.mosaic.isSearchByCurvesOn = true;
					this.mosaic.searchCanvas.onPointerIn(mainPointerX, mainPointerY, secondPointerX, secondPointerY);
					this.mosaic.canDrawNextCurve = true;
				}
				else if(this.mosaic.isSearchByCurvesOn)
				{
					if(this.mosaic.canDrawNextCurve)
					{
						this.mosaic.canDrawNextCurve = false;
						if(Math.abs(mainPointerX - this.mosaic.mainPointerLastX) > 10 || Math.abs(mainPointerY - this.mosaic.mainPointerLastY) > 10 || Math.abs(secondPointerX - this.mosaic.secondPointerLastX) > 10 || Math.abs(secondPointerY - this.mosaic.secondPointerLastY) > 10)
						{
							console.log('move');
							this.mosaic.searchCanvas.onPointerMove(mainPointerX, mainPointerY, secondPointerX, secondPointerY);
						}
					}
					else
					{
						this.mosaic.nextDrawCurveTimeout = setTimeout(function()
						{
							_this.mosaic.canDrawNextCurve = true;
						}, this.mosaic.config['timeoutNextDrawCurve']);
					}
				}
			}
		}
	}
	
	//Quant on a reçu un message, on vérifie la présence des deux pointeurs.
	this.mosaic.checkForBothPointersHere();
	
	if(this.mosaic.pointersIdleAvailable)
	{
		//On effectue une vérification de la position des pointeurs pour l'idle.
		this.mosaic.detectIdlePointers();
	}
	
	//Si le timeout a besoin d'être relancé ou bien que l'affichage de l'aide est disponible.
	if(this.mosaic.pointersIdleNeedLaunch || this.mosaic.canNotifyHelp)
	{
		// console.log('launch idle');
		this.mosaic.launchIdlePointers();
		this.mosaic.pointersIdleNeedLaunch = false;
	}
	
	//Si la détection d'idle n'est pas activée et qu'on est dans un mode permettant l'interaction de l'utilisateur. 
	if(!this.mosaic.pointersIdleAvailable && this.mosaic.currentMode != "NO-USER" && this.mosaic.currentMode.indexOf("INCOMING") == -1 && this.mosaic.areBothPointersHere)
	{
		//On enclenche la détection d'idle.
		this.mosaic.pointersIdleAvailable = true;
		this.mosaic.pointersIdleNeedLaunch = true;
	}
	// /!\/!\ //
}

/*
 * Permet d'envoyer un message au Middleware (optionnel).
*/
client.prototype.sendMessage = function(data)
{
	//Si data est un objet, on le change en chaine.
	if(typeof data === 'object')
	{
		data = JSON.stringify(data);
	}
	this.socket.send(data);
}