mosaic.prototype.playNextVideo = function()
{
	var videoId = this.centerId, nextId = (+videoId + 1);
	
	//Si on arrive à la fin de la mosaique on revient au début.
	if(videoId >= this.config['imagesToShow'] - 1)
	{
		nextId = 0;
	}
	
	//Si la mosaique est filtrée, on passe directement à la prochaine vidéo non filtrée.
	if(this.isMosaicFiltered)
	{
		while(this.opacities[nextId] == 0 && nextId < this.config['imagesToShow'])
		{
			nextId++;
		}
		
		if(nextId == this.config['imagesToShow'])
		{
			nextId = 0;
			// return;
		}
	}
	
	console.log('movetonext');
	this.autoMove = true;
	console.log('dep : ' + this.centerId + ' next : ' + nextId);
	this.moveToNeighbour($('#snapshotDiv-' + nextId));
}

mosaic.prototype.isTLSelected = function(entering, mainPointer)
{
	//Si les deux pointeurs ne sont pas là ou qu'on n'est pas en lecture d'une vidéo.
	if(this.isMainPointerDisplayed && this.isSecondPointerDisplayed || this.currentMode != 'VIDEO' && this.currentMode != 'SEARCH' && this.currentMode != 'TIMELINE' || !this.playerIsReady)
	{
		// $('.a').remove();
		return false;
	}
	
	var pointer;
	var Px, Py;
	
	if(this.mouseInteractions)
	{
		Px = this.mousePosX;
		Py = this.mousePosY;
	}
	else
	{
		pointer = (mainPointer ? $('#mainPointer') : $('#secondPointer'));
		Px = pointer.position().left + pointer.width() / 2;
		Py = pointer.position().top + pointer.height() / 2;
	}
	
	var TL = $('.Ldt-Timeline');
	var TLwidth = TL.width(), TLheight = TL.height();
	var TLtop = (+$('.LdtPlayer').position().top + $('.LdtPlayer').height() - TLheight), TLleft = $('.LdtPlayer').position().left;
	
	var correctHorizontalPosition = (entering ? (Px > TLleft && Px < (+TLleft + TLwidth)) : (true));
	
	//Seulement avec une main.
	// if(this.isMainPointerDisplayed && !this.isSecondPointerDisplayed && correctHorizontalPosition && Py > (TLtop - TLheight / 2) && Py < (+TLtop + TLheight))
	
	if(correctHorizontalPosition && Py > (TLtop - TLheight / 2) && Py < (+TLtop + TLheight))
	{
		// if($('.a').length < 1)
			// $('body').append('<div class="a" style="position: absolute; background-color: #fff; top: ' + (TLtop - TLheight / 2) + 'px; left: ' + TLleft + 'px; height: ' + (TLheight * 3 / 2) +'px; width: ' + TLwidth + 'px"></div>');
		return true;
	}
	
	// $(".a").remove();
	return false;
}

mosaic.prototype.exitTimeline = function(typeOfInteraction)
{
	if(this.currentMode == 'TIMELINE' && this.playerIsReady)
	{
		console.log('(5) QUIT');
		// console.trace();
		this.removeNotifications();
		
		this.isTLRequested = false;
		this.canSlideInTL = false;
		this.player.widgets[0].deselectTimeline();
		
		if($('#spinner').length > 0)
		{
			$('#spinner').remove();
		}
		
		if(this.isTLSelectedByMainPointer)
		{
			$('#mainPointer').css('background-image', 'url(./img/cursors/pointer.png)');
		}
		if(this.isTLSelectedBySecondPointer)
		{
			$('#secondPointer').css('background-image', 'url(./img/cursors/pointer2.png)');
		}
		
		this.isTLSelectedByMainPointer = false;
		this.isTLSelectedBySecondPointer = false;
		
		if(typeOfInteraction == 'unzoom')
		{
			if(this.isMosaicFiltered)
			{
				this.currentMode = 'FILTER';
			}
			else
			{
				this.currentMode = 'MOSAIC';
			}
		}
		else if(typeOfInteraction == 'move')
		{
			this.currentMode = 'VIDEO';
		}
		else
		{
			if(this.isCurrentlyInASearchByGesture)
			{
				this.currentMode = 'SEARCH';
				
				this.searchGesture(this.currentSearchGesture[this.centerId], 'valid');
			}
			else
			{
				this.currentMode = 'VIDEO';
			}
		}
	}
}