/*
* This file is part of the TraKERS\Front JS package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front JS
 * Fichier : client.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit le module de communication qui établit la connexion entre ce Front et le Middleware.
 */

/*
 * Un client est défini par une socket, qui permettra de recevoir les données du server websocket du Middleware.
 * On accède aussi à la classe des pointeurs.
*/
function client(host, port, _gestures)
{
    this.socket;
    this.gestures = _gestures;
    this.showGestureTimeout;
    
    this.createWebSocket('ws://' + host + ':' + port + '/');
}

/*
 * Création et Initialisation des sockets et listeners permettant d'écouter le server.
*/
client.prototype.createWebSocket = function(host)
{
    var _this = this;
    
    //Initialise la fonctionnalité websocket du naviguateur.
    if(window.MozWebSocket)
    {
        window.WebSocket = window.MozWebSocket;
    }
    
    //Si le naviguateur ne supporte pas les websockets, on s'arrête là.
    if(!window.WebSocket)
    {
        alert('Votre navigateur ne supporte pas les webSocket!');
        return false;
    }
    //Sinon
    else
    {
        //On initialise la socket.
        this.socket = new WebSocket(host);
        
        //Si elle est ouverte, on notifie le Front.
        this.socket.onopen = function()
        {
            console.log('Socket ouverte.');
        }
        //Si elle est fermée, on notifie le Front.
        this.socket.onclose = function()
        {
            console.log('Socket fermée.');
        }
        //S'il y a un problème dans la connection, on notifie le Front.
        this.socket.onerror = function()
        {
            console.log('Une erreur est survenue dans le module de Communication.');
        }
        //Si on reçoit un message.
        this.socket.onmessage = function(msg)
        {
            _this.processMsg(msg);
        }
    }
}

/*
 * Traite un message reçu du Middleware.
*/
client.prototype.processMsg = function(msg)
{
    if(typeof msg === 'undefined' || typeof msg.data === 'undefined')
    {
        return;
    }
    
    var _this = this;
    
    //Sinon si ce sont les coordonnées de la main droite.
    if(msg.data[0] == '2')
    {
        var instruction = msg.data.substring(2, msg.data.length);
        
        //S'il ne s'agit pas d'une gesture relative à la position de l'utilisateur par rapport à la Kinect.
        if(instruction != "NO-USER" && instruction.indexOf("INCOMING") == -1 && instruction != "MOSAIC" && instruction != "FILTER")
        {
            //On affiche la notification de gesture.
            this.gestures.showGesture(instruction);
        }
    }
}