﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : UserPositionListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur s'est déplacé dans la zone de
 * détection.
 * Il contient le code a être éxecuté au cas où cet événement survient.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.MainModule.Events
{
    public class UserPositionListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur s'est déplacé dans la zone de détection.
        */
        public void showAndSend(object o, UserPositionEventArgs e)
        {
            e.debug.showDistance(e.distance);
            e.server.GesturePerformed("MOSSHOW-" + e.imagesToShow);
        }
    }
}
