/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : mosaic.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" courbe et définit des fonctions d'intéractions (dessin...).
 */
 
function curve()
{
	tool.fixedDistance = 10;
	this.path;
	this.pathStroke;
	this.lastPoint;
}

curve.prototype.onPointerIn = function(pointerX, pointerY)
{
	this.pathStroke = new Path();
	this.path = new Path();
	
	var point = new paper.Point(pointerX, pointerY);
	
	if(!this.lastPoint)
	{
		this.lastPoint = point;
	}
	
	this.pathStroke.fillColor = '#366F7A';
	this.path.fillColor = '#02FEFF';
};

curve.prototype.onPointerMove = function(pointerX, pointerY)
{
	var point = new paper.Point(pointerX, pointerY);
	
	var delta = new paper.Point(this.lastPoint.x - point.x, this.lastPoint.y - point.y);
	
	var step = delta / 5;
	var stepStroke = delta / 3;
	step.angle += 90;
	stepStroke.angle += 90;

	var top = point + step;
	var bottom = point - step;
	
	var topStroke = point + stepStroke;
	var bottomStroke = point - stepStroke;

	this.path.add(top);
	this.path.insert(0, bottom);
	this.path.smooth();
	
	this.pathStroke.add(topStroke);
	this.pathStroke.insert(0, bottomStroke);
	this.pathStroke.smooth();
	
	this.lastPoint = point;
};

curve.prototype.onMouseUp = function(pointerX, pointerY)
{
	this.pathStroke.remove();
	this.path.remove();
};

curve.prototype.onKeyDown = function(event)
{
	//S'il n'y a rien a colorier, on quitte.
	if(typeof this.pathStroke === 'undefined' || typeof this.path === 'undefined')
		return;
	
	if(event.key == 'r' || event.key == 'R')
	{
		this.pathStroke.fillColor = '#49564F';
		this.path.fillColor = '#00FE00'
	}
	else if(event.key == 'x' || event.key == 'X')
	{
		this.pathStroke.fillColor = '#535F6D';
		this.path.fillColor = '#CCCCCC'
	}
	else if(event.key == 'w' || event.key == 'W')
	{
		this.pathStroke.fillColor = '#366F7A';
		this.path.fillColor = '#02FEFF'
	}
};