/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : playerControl.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit les fonctions d'interaction avec le player dans la mosaique.
 */

/*
 * Passe à une vidéo suivante pour la lire, peut passer d'une vidéo à une autre en cas de filtrage.
 * Est appelé : dans le fichier mosaic > fonctions manageControlEvents et onPlayerLoad.
*/
Mosaic.prototype.playNextVideo = function()
{
    //Définit l'id du snapshot principal et le suivant à lire.
    var videoId = this.centerId, nextId = (+videoId + 1);
    
    //Si on arrive à la fin de la mosaique on revient au début.
    if(videoId >= this.config.imagesToShow - 1)
    {
        nextId = 0;
    }
    
    //Si la mosaique est filtrée, on passe directement à la prochaine vidéo non filtrée.
    if(this.isMosaicFiltered)
    {
        //Tant que la vidéo est masquée par un filtre de recherche, on passe à la vidéo suivante.
        while(this.opacities[nextId] == 0 && nextId < this.config.imagesToShow)
        {
            nextId++;
        }
        
        //Si on arrive à la fin on revient au début.
        if(nextId == this.config.imagesToShow)
        {
            nextId = 0;
        }
    }
    
    //On se déplace vers la prochaine vidéo à lire.
    this.autoMove = true;
    this.moveToNeighbour($('#snapshotDiv-' + nextId));
}

/*
 * Indique si la timeline est sélectionnée.
 * Est appelé : dans le fichier pointers > fonctions mainPointerDisplay et pointersTimelineSelection.
*/
Mosaic.prototype.isTLSelected = function(entering, mainPointer)
{
    //Si les deux pointeurs ne sont pas là ou qu'on n'est pas en lecture d'une vidéo.
    if(this.isMainPointerDisplayed && this.isSecondPointerDisplayed || this.currentMode != 'VIDEO' && this.currentMode != 'SEARCH' && this.currentMode != 'TIMELINE' || !this.playerIsReady)
    {
        return false;
    }
    
    var pointer;
    var Px, Py;
    
    //Si on est en mode d'interaction souris.
    if(this.config.mouseInteractions)
    {
        //On met à jour la position estimée de la souris.
        Px = this.mousePosX;
        Py = this.mousePosY;
    }
    else
    {
        //Sinon on se fie à la position des pointeurs.
        pointer = (mainPointer ? $('#mainPointer') : $('#secondPointer'));
        Px = pointer.position().left + pointer.width() / 2;
        Py = pointer.position().top + pointer.height() / 2;
    }
    
    //Si le pointeur se situe sur la timeline, on renvoie vrai, sinon faux.
    var TL = $('.Ldt-Timeline');
    var TLwidth = TL.width(), TLheight = TL.height();
    var TLtop = (+$('.LdtPlayer').position().top + $('.LdtPlayer').height() - TLheight), TLleft = $('.LdtPlayer').position().left;
    
    var correctHorizontalPosition = (entering ? (Px > TLleft && Px < (+TLleft + TLwidth)) : (true));
    
    if(correctHorizontalPosition && Py > (TLtop - TLheight / 2) && Py < (+TLtop + TLheight))
    {
        return true;
    }
    
    return false;
}

/*
 * Sert à déselectionner la timeline.
 * Est appelé : dans les fichiers neighbours > fonction moveToNeighbour, pointers > fonctions mainPointerDisplay, secondPointerDisplay et pointersTimelineSelection et zoomInteractions > fonction unzoom.
*/
Mosaic.prototype.exitTimeline = function(typeOfInteraction)
{
    //Si on est en mode timeline et que le player est prêt.
    if(this.currentMode == 'TIMELINE' && this.playerIsReady)
    {
        //On enlève les notifications.
        this.removeNotifications();
        
        //On remet à zéro les variables concernées.
        this.isTLRequested = false;
        this.canSlideInTL = false;
        //On déselectionne la timeline au niveau du player.
        this.player.widgets[0].deselectTimeline();
        
        if($('#spinner').length > 0)
        {
            $('#spinner').remove();
        }
        
        //On remet l'apparence des pointeurs.
        if(this.isTLSelectedByMainPointer)
        {
            $('#mainPointer').css('background-image', 'url(./img/cursors/pointer.png)');
        }
        if(this.isTLSelectedBySecondPointer)
        {
            $('#secondPointer').css('background-image', 'url(./img/cursors/pointer2.png)');
        }
        
        this.isTLSelectedByMainPointer = false;
        this.isTLSelectedBySecondPointer = false;
        
        //On revient dans le mode précédent, en fonction de l'action effectuée pour quitter la timeline.
        //Si l'action était juste de mettre le pointeur hors de la timeline, on revient en mode video/search en fonction de l'existence d'une gesture de recherche.
        if(typeOfInteraction == 'unzoom')
        {
            if(this.isMosaicFiltered)
            {
                this.currentMode = 'FILTER';
            }
            else
            {
                this.currentMode = 'MOSAIC';
            }
        }
        else if(typeOfInteraction == 'move')
        {
            this.currentMode = 'VIDEO';
        }
        else
        {
            if(this.isCurrentlyInASearchByGesture)
            {
                this.currentMode = 'SEARCH';
                
                this.searchGesture(this.currentSearchGesture[this.centerId], 'valid');
            }
            else
            {
                this.currentMode = 'VIDEO';
            }
        }
    }
}