/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

// fluid3 by Glen Murphy.
// View the applet in use at http://bodytag.org/
// Code has not been optimised, and will run fairly slowly.

// Adjust the 'RES' variable below to change speed - higher is faster.
// Don't forget to change the size command in setup if changing the
// height/width.

import TUIO.*;
TuioProcessing tuioClient;

TuioPoint precPoint;

//Port du Client TUIO.
int port = 80;
//Limites de la zone de recherche pour les mains.
float minDistHands = 1;
float maxDistHands = 1.5;
//Paramètres de la fenêtre.
int WIDTH = 640;
int HEIGHT = 480;

int RES = 2;
int PENSIZE = 30;

int lwidth = WIDTH/RES;
int lheight = HEIGHT/RES;
int PNUM = 30000;
vsquare[][] v = new vsquare[lwidth+1][lheight+1];
vbuffer[][] vbuf = new vbuffer[lwidth+1][lheight+1];

TuioPoint pt1, pt2, precPt1, precPt2;

particle[] p = new particle[PNUM];
int pcount = 0;
int mouse1Xvel = 0;
int mouse1Yvel = 0;
int mouse2Xvel = 0;
int mouse2Yvel = 0;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Création de la fenêtre et du client TUIO*/
public void setup()
{
    size (WIDTH, HEIGHT);
    tuioClient = new TuioProcessing(this, port);
    
    background(#666666);
    noStroke();
    for(int i = 0; i < PNUM; i++)
    {
        p[i] = new particle(random(RES,WIDTH-RES),random(RES,HEIGHT-RES));
    }
    for(int i = 0; i <= lwidth; i++)
    {
        for(int u = 0; u <= lheight; u++)
        {
            v[i][u] = new vsquare(i*RES,u*RES);
            vbuf[i][u] = new vbuffer(i*RES,u*RES);
        }
    }
}

void draw()
{
    tuioInput();
    if(precPt1 != pt1 || precPt2 != pt2)
    {
      int a1xvel = 0, a1yvel = 0, a2xvel = 0, a2yvel = 0;
      if(precPt1 != null && pt1 != null)
      {
        a1xvel = (int)pt1.getX()-(int)precPt1.getX();
        a1yvel = (int)pt1.getY()-(int)precPt1.getY();
        mouse1Xvel = (a1xvel != mouse1Xvel) ? a1xvel : 0;
        mouse1Yvel = (a1yvel != mouse1Yvel) ? a1yvel : 0;
      }
      if(precPt2 != null && pt2 != null)
      {
        a2xvel = (int)pt2.getX()-(int)precPt2.getX();
        a2yvel = (int)pt2.getY()-(int)precPt2.getY();
        mouse2Xvel = (a2xvel != mouse2Xvel) ? a2xvel : 0;
        mouse2Yvel = (a2yvel != mouse2Yvel) ? a2yvel : 0;
      }
      
      for(int i = 0; i < lwidth; i++)
      {
          for(int u = 0; u < lheight; u++)
          {
              vbuf[i][u].updatebuf(i,u);
              v[i][u].col = 32;
          }
      }
      for(int i = 0; i < PNUM-1; i++)
      {
          p[i].updatepos();
      }
      for(int i = 0; i < lwidth; i++)
      {
          for(int u = 0; u < lheight; u++)
          {
              v[i][u].addbuffer(i, u);
              v[i][u].updatevels(mouse1Xvel, mouse1Yvel, pt1);
              if(pt2 != null)
                v[i][u].updatevels(mouse2Xvel, mouse2Yvel, pt2);
              v[i][u].display(i, u);
          }
      }
      
      precPt1 = pt1;
      precPt2 = pt2;
    }
}

void update(TuioPoint _pt1, TuioPoint _pt2)
{
  pt1 = _pt1;
  pt2 = _pt2;
}
