/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : PushEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : L'utilisateur a effectué un push.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Tracking.Gestures;
using Trakers.Debug;
using Trakers.Communication;

namespace Trakers.MainModule.Events
{
    public class PushEventArgs : MainEventArgs
    {
        //Direction du push.
        public readonly PushDetector.Direction direction;
        //Main ayant réalisé le push.
        public readonly PushDetector.Hand hand;

        /*
        * Constructeur : Il prend l'affichage de debug, le serveur TUIO et la direction du swipe.
        */
        public PushEventArgs(Server _server, DebugWindow _debug, PushDetector.Direction _direction, PushDetector.Hand _hand) : base(_server, _debug)
        {
            direction = _direction;
            hand = _hand;
        }
    }
}
