﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Gestures
 * Classe : JumpDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur a sauté, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 * 
 * P.S : Cette partie est encore en développement.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Postures
{
    public class FallDetector : PostureDetector
    {
        static int n = 0;

        public FallDetector(DebugWindow _debug)
            : base(_debug)
        {
        }

        /*
         * Méthode de détection du fall.
         */
        public bool CheckForFall()
        {
            //Crée un état local afin de pouvoir analyser s'il y a une posture.
            List<Joint> localState = new List<Joint>(currentState);

            /*if (localState[(int)JointType.KneeLeft].Position.Z + 0.10 < localState[(int)JointType.HipCenter].Position.Z)
                debug.onR0(true);
            else
                debug.onR0(false);
            if(localState[(int)JointType.KneeRight].Position.Z + 0.10 < localState[(int)JointType.HipCenter].Position.Z)
                debug.onR1(true);
            else
                debug.onR1(false);
            if (Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.Head].Position.Z) <= 0.20)
                debug.onR2(true);
            else
                debug.onR2(false);*/

            //Si les genoux ne sont pas éloignés d'au moins 20cm vers l'avant par rapport aux hanches
            //OU si les hanches et la tête ne sont pas au même niveau avec 20 cm d'erreur.
            //Alors on ne fait pas un fall.
            if (localState[(int)JointType.KneeLeft].Position.Z + 0.15 >= localState[(int)JointType.HipCenter].Position.Z ||
                localState[(int)JointType.KneeRight].Position.Z + 0.15 >= localState[(int)JointType.HipCenter].Position.Z ||
                //||
                Math.Abs(localState[(int)JointType.HipCenter].Position.Z - localState[(int)JointType.Head].Position.Z) > 0.20)
                return false;
            return true;
        }
    }
}
