﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Postures
 * Classe : BendDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur est bien tracké.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Postures
{
    public class CorrectPosture : PostureDetector
    {
        public CorrectPosture(DebugWindow _debug)
            : base(_debug)
        {
        }

        /*
         * Méthode de détection du penché.
         */
        public bool CheckForCorrectPosture()
        {
            //Crée un état local afin de pouvoir analyser s'il y a une posture.
            List<Joint> localState = new List<Joint>(currentState);

            bool c1, c2, c3, c4, c5, c6, c7, c8, c9, c10, c11, c12, c13;

            //Si les genoux sont plus hauts que le centre
            //OU si les pieds sont plus hauts que le centre
            //OU si la tête est plus basse que les hanches
            //OU si les épaules sont plus basses que les genoux
            //OU si les épaules droites et gauches sont trop proches
            //OU si les genoux droites et gauches sont trop proches
            //OU si les pieds sont plus hauts que les genoux, les genoux étant plus bas que le bassin
            //OU si les genoux sont inversés par rapport aux épaules
            //Alors on ne s'est pas tracké.
            c1 = localState[(int)JointType.KneeLeft].Position.Y < localState[(int)JointType.Spine].Position.Y;
            c2 = localState[(int)JointType.KneeRight].Position.Y < localState[(int)JointType.Spine].Position.Y;
            c3 = localState[(int)JointType.FootLeft].Position.Y < localState[(int)JointType.Spine].Position.Y;
            c4 = localState[(int)JointType.FootRight].Position.Y < localState[(int)JointType.Spine].Position.Y;
            c5 = localState[(int)JointType.Head].Position.Y > localState[(int)JointType.HipCenter].Position.Y;
            c6 = localState[(int)JointType.ShoulderCenter].Position.Y > localState[(int)JointType.KneeLeft].Position.Y;
            c7 = localState[(int)JointType.ShoulderCenter].Position.Y > localState[(int)JointType.KneeRight].Position.Y;
            c8 = Math.Abs(localState[(int)JointType.ShoulderLeft].Position.X - localState[(int)JointType.ShoulderRight].Position.X) < 0.20;
            c9 = Math.Abs(localState[(int)JointType.KneeLeft].Position.X - localState[(int)JointType.KneeRight].Position.X) < 0.20;
            c10 = localState[(int)JointType.FootLeft].Position.Y < localState[(int)JointType.KneeLeft].Position.Y && localState[(int)JointType.KneeLeft].Position.Y > localState[(int)JointType.HipCenter].Position.Y;
            c11 = localState[(int)JointType.FootRight].Position.Y < localState[(int)JointType.KneeRight].Position.Y && localState[(int)JointType.KneeRight].Position.Y > localState[(int)JointType.HipCenter].Position.Y;
            c12 = localState[(int)JointType.ShoulderRight].Position.X < localState[(int)JointType.ShoulderLeft].Position.X && localState[(int)JointType.KneeRight].Position.X > localState[(int)JointType.KneeLeft].Position.X;
            c13 = localState[(int)JointType.ShoulderRight].Position.X > localState[(int)JointType.ShoulderLeft].Position.X && localState[(int)JointType.KneeRight].Position.X < localState[(int)JointType.KneeLeft].Position.X;
            if (c1 || c2 || c3 || c4 || c5 || c6 || c7 || c8 || c9 || c10 || c11 || c12 || c13)
            {
                //debug.showCorrect(c1, c2, c3, c4, c5, c6, c7, c8, c9, c12, c13);
                //Console.WriteLine("NOT DETECTED");
                return false;
            }
            return true;
        }
    }
}
