/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : localMosaic.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" mosaïque locale (lors d'un zoom sur une mosaïque) et définit des fonctions d'intéractions.
 */

/*
 * Classe définissant la mosaïque locale.
 * Elle sera toujours de la forme 3x3, même si toutes les cases ne seront pas remplies par des snapshots (cas des bords et coins).
*/
function localMosaic(len, imgToShow, marginWidth)
{
    if(imgToShow % len == 0)
    {
        this.length = len;
        this.imagesToShow = imgToShow;
        this.centerId;
        this.urls = [];
        this.imgs = [];
        this.ids = [];
        this.width;
        this.height;
        this.marginWidth = marginWidth;
        this.zoomed;
        this.snapshotTop;
        this.snapshotLeft;
        this.snapshotWidth;
        this.snapshotHeight;
    }
    else
    {
        //Affiche un message d'erreur.
    }
}

/*
 * Crée la mosaïque locale, qui est une partie de la mosaïque de mosaic.js.
 * Il y a le snapshot sur lequel on a zoomé, et les 8 snapshots voisins.
*/
localMosaic.prototype.createLocalMosaic = function()
{
    var str = '';
    
    var t = this.coord1Dto2D(this.centerId);
    var localId;
    
    for(var a = t[1] - 1 ; a < t[1] + 2 ; a++)
        for(var b = t[0] - 1 ; b < t[0] + 2 ; b++)
            if(a > -1 && a < this.imagesToShow / this.length && b > -1 && b < this.length)
            {
                localId = this.coord2Dto1D(a, b);
                str += '<div class="snapshotDivs"><img id="snapshot-' + localId + '" class="snapshots" src="snapshots-little/' + this.imgs[localId] + '" /></div>';
            }
            else
                str += '<div class="blacks"></div>';
    
    return str;
}

/*
 * Permet de charger la mosaïque locale.
*/
localMosaic.prototype.loadLocalMosaic = function(snTop, snLeft, snWidth, snHeight, imgsTab, id)
{
    //On affecte les chemins vers les images à la mosaïque.
    this.imgs = imgsTab;
    this.centerId = id;
    this.snapshotTop = snTop;//*(newPreMPHeight/initMPHeight) - this.zoomedMargin/2 + (initMPHeight - initMPHeight * this.zoomPercentage)/2 + 'px';
    this.previousMPLeft = snLeft;
    this.snapshotWidth = snWidth;
    this.snapshotHeight = snHeight;
    //On met à jour la mosaïque.
    $('#mainPanel').html(this.createLocalMosaic(id));
    $('.snapshotDivs').css('width', snWidth).css('height', snHeight).css('margin', this.marginWidth/2);
    // var lMosTop = , newZoomLeft = -this.previousZoomedSN.position().left*(newPreMPWidth/initMPWidth) - this.zoomedMargin/2 + (initMPWidth - initMPWidth * this.zoomPercentage)/2 + 'px';
    $('#mainPanel').css('top', 0).css('left', 0);
}

/*
 * Change de 1 à 2 dimensions pour les coordonnées des snapshots dans la mosaïque.
*/
localMosaic.prototype.coord1Dto2D = function(i)
{
    return [i%length, Math.floor(i/this.length)];
}

/*
 * Change de 2 à 1 dimension pour les coordonnées des snapshots dans la mosaïque.
*/
localMosaic.prototype.coord2Dto1D = function(i, j)
{
    return j * this.length + i;
}