﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Postures
 * Classe : PostureDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Reçoit la position des noeuds les plus récents envoyés par la classe de manipulation de la Kinect.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Debug;
using Microsoft.Kinect;

namespace Trakers.Tracking.Postures
{
    public class PostureDetector
    {
        public DebugWindow debug;

        //Liste des positions du squelette.
        protected static List<Joint> currentState = new List<Joint>();

        //Distance de référence.
        protected float refDistance;

        public PostureDetector(DebugWindow _debug)
        {
            debug = _debug;
        }

        //Stocke les positions les plus récentes du squelette.
        public static void UpdateSkeletonState(List<Joint> latestSkeleton)
        {
            currentState = latestSkeleton;
        }
    }
}
