/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

import TUIO.*;
TuioProcessing tuioClient;
//Indique s'il s'agit de la main gauche.
boolean oneHandLeft;

//Taille de la fenêtre
int WIDTH = 640, HEIGHT = 480;

//Port du Client TUIO
int port = 80;
float minDistHands = 1;
float maxDistHands = 1.5;

/*FONCTION D'INITIALISATION
Entrée :
Sortie : Cr�ation de la fenêtre et du client TUIO*/
void setup()
{
    size (WIDTH, HEIGHT);
    showMask();
    tuioClient = new TuioProcessing(this, port);
    textAlign(CENTER);
    imageMode(CENTER);
    smooth();
}

/*FONCTION DE DESSIN
Entrée :
Sortie : Appel à la fonction de traitement d'input du serveur toutes les n millisecondes*/
void draw()
{
    fill(0);
    tuioInput();
    noStroke();
}

/*FONCTION DE GENERATION DU MASQUE
Entrée :
Sortie : Place des rectangles autour de la zone de dessin*/
void showMask()
{
    background(0);
    fill(255);
    rect(0, 80, width, height-130);
}
	
/*FONCTION DE RAFFRACHISSEMENT DU TEXTE SUPERIEUR
Entrée : Texte à afficher
Sortie : Place un rectangle au dessus de la zone de dessin et raffraichit le texte*/
void refreshText(String txt1, String txt2)
{
    fill(0);
    rect(0, 0, width, 80);
    fill(255);
    text(txt1, width/2 - 20, 20);
    text(txt2, width/2 - 20, 40);
}

/*FONCTION DE DESSIN D'UN POINT DE COURBE
Entrée : Coordonnées X, Y et Z d'un point
Sortie : Le point est dessiné avec une épaisseur et une luminosité dépendant de Z*/
void drawEllipse(float x, float y, float z, boolean leftHand)
{

    fill(0, 0, 255);
    stroke(0,0,0);

    float weight = map(z, minDistHands, maxDistHands, 50, 1);
    float redColor = map(z, minDistHands, maxDistHands, 255, 80);
    
    if(leftHand)
        fill(redColor,0,0);
    else
        fill(0,redColor,0);
    
    if(weight >= 30)
        fill(0, 0, redColor);
    
    ellipse(x+20, y+100, weight, weight);
}
