/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

/*FONCTION DE RECEPTION DES MESSAGES OSC
Entrée :
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void tuioInput()
{
    noFill();
    Vector tuioCursorList = tuioClient.getTuioCursors();
    	
    if(tuioCursorList.size() == 1)
    {
        handleOneHand((TuioCursor)tuioCursorList.elementAt(0));
    }
    else if(tuioCursorList.size() == 2)
    {
        handleBothHands(tuioCursorList);
    }
}

/*FONCTION DE GESTION DES COURBES POUR UNE MAIN DETECTEE
Entrée : Un curseur TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleOneHand(TuioCursor handCursor)
{
    TuioPoint pt = handCursor.getPosition();
    fill(0);
    update((int)pt.getX());
}

/*FONCTION DE GESTION DES COURBES POUR DEUX MAINS DETECTEES
Entrée : La liste des curseurs TUIO
Sortie : Appel aux différentes fonctions de dessin si un message est reçu*/
void handleBothHands(Vector tuioCursorList)
{
    TuioCursor handLeftCursor = (TuioCursor)tuioCursorList.elementAt(0);
    TuioCursor handRightCursor = (TuioCursor)tuioCursorList.elementAt(1);
    TuioPoint ptLeft = handLeftCursor.getPosition(), ptRight = handRightCursor.getPosition(), ptNearest;

    ptNearest = (ptLeft.getZ() < ptRight.getZ()) ? ptLeft : ptRight;
    update((int)ptNearest.getX());
}


