function searchCanvas(_canvasTop, _canvasLeft, _canvasWidth, _canvasHeight, _margin_top, _fadeTime, _inMosaic)
{
	this.canvasTop = _canvasTop;
	this.canvasLeft = _canvasLeft;
	this.canvasWidth = _canvasWidth;
	this.canvasHeight = _canvasHeight;
	this.fadeTime = _fadeTime;
	this.margin_top = _margin_top;
	
	//tool.fixedDistance = 10;
	this.path;
	this.pathStroke;
	this.lastPoint;
	
	this.inMosaic = _inMosaic;
	
	this.hitTool = new paper.Tool();
	this.hitTool.fixedDistance = 10;
	this.hitTool.activate();
}

searchCanvas.prototype.create = function()
{
	var _this = this;
	
	var canvas = '<canvas id="paperCanvas" width="' + this.canvasWidth + 'px" height="' + this.canvasHeight + 'px" class="canvas"></canvas>';
	
	$('body').append(canvas);
	
	$('.canvas').css(
	{
		top: this.canvasTop,
		left: this.canvasLeft
	});
	
	if(this.inMosaic)
	{
		console.log(this.margin_top);
		$('.canvas').css(
		{
			"margin-top": this.margin_top
		});
	}
	
	paper.setup('paperCanvas');
	
	this.hitTool.onMouseDown = this.onMouseDown;
	this.hitTool.onMouseDrag = this.onMouseDrag;
	this.hitTool.onMouseUp = this.onMouseUp;
	this.hitTool.onKeyDown = this.onKeyDown;
};

searchCanvas.prototype.leaveSearch = function()
{
	$('.canvas').fadeTo(this.fadeTime, 0, function()
	{
		$('.canvas').remove();
	});
};

searchCanvas.prototype.onMouseDown = function(event)
{
	this.pathStroke = new paper.Path();
	this.path = new paper.Path();
	
	this.pathStroke.fillColor = '#366F7A';
	this.path.fillColor = '#02FEFF';
	
	this.pathStroke.add(event.point);
};

searchCanvas.prototype.onMouseDrag = function(event)
{
	var step = event.delta.divide(new paper.Point(4, 4));
	var stepStroke = event.delta.divide(new paper.Point(2, 2));
	step.angle += 90;
	stepStroke.angle += 90;

	var top = event.middlePoint.add(step);
	var bottom = event.middlePoint.add(step.negate());

	var topStroke = event.middlePoint.add(stepStroke);
	var bottomStroke = event.middlePoint.add(stepStroke.negate());

	this.path.add(top);
	this.path.insert(0, bottom);
    this.path.smooth();
	
	this.pathStroke.add(topStroke);
	this.pathStroke.insert(0, bottomStroke);
    this.pathStroke.smooth();
};

searchCanvas.prototype.onMouseUp = function(event)
{
	this.pathStroke.remove();
	this.path.remove();
};

searchCanvas.prototype.onKeyDown = function(event)
{
	//S'il n'y a rien a colorier, on quitte.
	if(typeof this.pathStroke === 'undefined' || typeof this.path === 'undefined')
		return;
	
	if(event.key == 'r' || event.key == 'R')
	{
		this.pathStroke.fillColor = '#49564F';
		this.path.fillColor = '#00FE00'
	}
	else if(event.key == 'x' || event.key == 'X')
	{
		this.pathStroke.fillColor = '#535F6D';
		this.path.fillColor = '#CCCCCC'
	}
	else if(event.key == 'w' || event.key == 'W')
	{
		this.pathStroke.fillColor = '#366F7A';
		this.path.fillColor = '#02FEFF'
	}
};