/*
* This file is part of the TraKERS\Front JS package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front JS
 * Fichier : pointers.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" de gestion des pointers et définit des fonctions d'intéraction.
 */

/*
 * Classe définissant les pointers.
 */
function Pointers(config)
{
    this.mainPointerLastX = 0;
    this.mainPointerLastY = 0;
    this.secondPointerLastX = 0;
    this.secondPointerLastY = 0;
	
	this.isMainPointerDisplayed = false;
	this.isSecondPointerDisplayed = false;
	
	this.pointerLeftTimeout = null;
	this.pointerRightTimeout = null;
	
	this.config = config;
	
	this.client = new Client(this.config.host, this.config.port, this);
	
	this.addPointers();
}

/*
 * Affiche les pointeurs.
*/
Pointers.prototype.addPointers = function()
{
    var mainPointer = '<div id="mainPointer" class="pointers"></div>';
    var secondPointer = '<div id="secondPointer" class="pointers"></div>';
	var textPanel = "<div id='textPanel'>Les mains sont trop loin ou trop près.</div>";
    $('body').append(textPanel + mainPointer + secondPointer);
    
    $('#secondPointer').css(
    {
        top: $(window).height() / 2 - $('#secondPointer').height() / 2,
        left: $(window).width() / 4 - $('#secondPointer').width() / 2,
		opacity: 0
    });
    
    this.secondPointerLastX = $(window).width() / 4 - $('#secondPointer').width() / 2;
    this.secondPointerLastY = $(window).height() / 2 - $('#secondPointer').height() / 2;
    
    $('#mainPointer').css(
    {
        top: $(window).height() / 2 - $('#mainPointer').height() / 2,
        left: $(window).width() * 3 / 4 - $('#mainPointer').width() / 2,
		opacity: 0
    });

    this.mainPointerLastX = $(window).width() * 3 / 4 - $('#mainPointer').width() / 2;
    this.mainPointerLastY = $(window).height() / 2 - $('#mainPointer').height() / 2;
}

/*
 * Affiche/Masque le pointeur principal.
 * Main est un booléen valant vrai s'il faut afficher le pointeur.
*/
Pointers.prototype.mainPointerDisplay = function(main)
{
    var _this = this;
    
    //Si le booléen est à vrai, on affiche le pointeur.
    if(main)
    {
        $('#mainPointer').fadeTo(this.config.timeFilling, '1');
    }
    else
    {
        $('#mainPointer').fadeTo(this.config.timeFilling, '0');
    }
}
/*
 * Affiche/Masque le pointeur secondaire.
 * Main est un booléen valant vrai s'il faut afficher le pointeur.
*/
Pointers.prototype.secondPointerDisplay = function(second)
{
    var _this = this;
    
    //Si le booléen est à vrai, on affiche le pointeur.
    if(second)
    {
        $('#secondPointer').fadeTo(this.config.timeFilling, '1');
    }
    else
    {
        $('#secondPointer').fadeTo(this.config.timeFilling, '0');
    }
}

/*
 * Raffraîchit la position des pointeurs.
*/
Pointers.prototype.refreshMainPointer = function(x, y)
{
    x *= 7;
    y *= 7;
    x -= $(window).width() * 3 / 4;
    y -= $(window).height() * 2 / 4;
    
    //Si le pointeur quitte la fenêtre en X, on ne le change pas.
    if(x < 0 || x > $(window).width())
    {
        x = this.mainPointerLastX;
    }
    //Sinon, on le met à jour.
    else
    {
        this.mainPointerLastX = x;
    }
    
    //Si le pointeur quitte la fenêtre en Y, on ne le change pas.
    if(y < 0 || y > $(window).height())
    {
        y = this.mainPointerLastY;
    }
    //Sinon, on le met à jour.
    else
    {
        this.mainPointerLastY = y;
    }
    
    var pointerX = x - $('#mainPointer').width()/2, pointerY = y - $('#mainPointer').height()/2;
    var _this = this;
    
    $('#mainPointer').css(
    {
        top: pointerY,
        left: pointerX
    });
}

Pointers.prototype.refreshSecondPointer = function(x, y)
{
    if(!this.mouseInteractions)
    {
        x *= 7;
        y *= 7;
        x -= $(window).width() * 3 / 4;
        y -= $(window).height() * 2 / 4;
    }
    
    //Si le pointeur quitte la fenêtre en X, on ne le change pas.
    if(x < 0 || x > $(window).width())
    {
        x = this.secondPointerLastX;
    }
    //Sinon, on le met à jour.
    else
    {
        this.secondPointerLastX = x;
    }
    
    //Si le pointeur quitte la fenêtre en Y, on ne le change pas.
    if(y < 0 || y > $(window).height())
    {
        y = this.secondPointerLastY;
    }
    //Sinon, on le met à jour.
    else
    {
        this.secondPointerLastY = y;
    }
    
    var pointerX = x - $('#secondPointer').width()/2, pointerY = y - $('#secondPointer').height()/2;
    var _this = this;
    
    $('#secondPointer').css(
    {
        top: pointerY,
        left: pointerX
    });
}

/*
 * Met à jour l'affichage du texte.
*/
Pointers.prototype.textUpdate = function()
{
	if(this.isMainPointerDisplayed && this.isSecondPointerDisplayed)
	{
		$('#textPanel').html('Les deux pointeurs sont détectés.');
	}
	else if(this.isMainPointerDisplayed && !this.isSecondPointerDisplayed)
	{
		$('#textPanel').html('Le pointer droit est détecté.');
	}
	else if(!this.isMainPointerDisplayed && this.isSecondPointerDisplayed)
	{
		$('#textPanel').html('Le pointeur gauche est détecté.');
	}
	if(!this.isMainPointerDisplayed && !this.isSecondPointerDisplayed)
	{
		$('#textPanel').html('Les mains sont trop loin ou trop près.');
	}
}