/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : ModChangeListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : On change de mode.
 * Il contient le code a être éxecuté au cas où cet événement survient, à savoir :
 * - On affiche un visuel dans le debug.
 * - On notifie le serveur TUIO.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Trakers.MainModule.Events
{
    public class ModChangeListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : On change de mode.
        */
        public void showAndSend(object o, ModChangeEventArgs e)
        {
            //e.debug.showGesture(e.code);
            e.server.ModeNotification(e.code);
        }
    }
}
