/*
* This file is part of the TraKERS\Front IDILL package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front IDILL
 * Fichier : mouseInteractions.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit les fonctions d'intéraction souris.
 */

/*
 * Fonction appelée lors d'un mouse down en mode d'interaction souris.
 * Est appelé dans le fichier :
 * mosaic > fonction loadMosaic, attachée à l'événement jQuery mousedown.
*/
Mosaic.prototype.onMouseDown = function(e)
{
	this.isMouseDown = true;
	
	//Si on se trouve sur l'icone d'aide et qu'elle est zoomée.
	if(this.isHelpIconZoomed)
	{
		//On affiche différentes aides en fonction de si on se trouve dans une vidéo ou non.
		if(this.currentMode == 'SEARCH' || this.currentMode == 'VIDEO' || this.currentMode == 'TIMELINE')
		{
			this.notifyHelp(false);
		}
		else if(this.currentMode == 'FILTER' || this.currentMode == 'MOSAIC')
		{
			this.notifyHelp(true);
		}
	}
	
	//Si on se trouve sur l'icone des crédits et qu'elle est zoomée.
	if(this.isCreditsIconZoomed)
	{
		//On affiche les crédits.
		this.notifyCredits();
	}
	
	//On met à jour les coordonnées de la souris au dernier mouse down.
	this.mouseDownPosX = e.pageX;
	this.mouseDownPosY = e.pageY;
	
	//Si on est sur une notification de gesture de recherche.
	this.removeSearchNotificationIfOnIt(e.pageX, e.pageY);
	this.isUserInSearchZone = true;
	
	//Si on est en mode de tracé de courbes, on indique qu'on a commencé à tracer au canvas.
	if(this.isSearchByCurvesOn)
	{
		this.searchCanvas.onPointerIn(this.mousePosX, this.mousePosY, null, null);
	}
}

/*
 * Fonction appelée lors d'un mouse move en mode d'interaction souris.
 * Est appelé dans le fichier :
 * mosaic > fonction loadMosaic, attachée à l'événement jQuery mousemove.
*/
Mosaic.prototype.onMouseMove = function(e)
{
	//On vérifie si la souris n'est pas sur l'icone d'aide.
	if(this.isOnHelpIcon(this.mousePosX, this.mousePosY))
	{
		//On agrandit l'icone d'aide.
		this.showBigHelp();
	}
	else
	{
		//On la rétrecit sinon.
		this.showSmallHelp();
	}

	//On vérifie si la souris n'est pas sur l'icone des crédits.
	if(this.isOnCreditsIcon(this.mousePosX, this.mousePosY))
	{
		//On agrandit l'icone des crédits.
		this.showBigCredits();
	}
	else
	{
		//On la rétrecit sinon.
		this.showSmallCredits();
	}
	
	//Si on n'a pas appuyé sur la souris avant, on part.
	if(!this.isMouseDown)
	{
		return;
	}
	
	var _this = this;
	
	//Si on est en mode de tracé de courbes, on met à jour la courbe.
	if(this.isSearchByCurvesOn)
	{
		// this.searchCanvas.onPointerMove(this.mousePosX, this.mousePosY - this.MPTop_margin, null, null);
		this.searchCanvas.onPointerMove(this.mousePosX, this.mousePosY, null, null);
	}
	
	//On met à jour l'ancienne position de la souris si elle est nulle.
	if(!this.mousePosLastX && this.mousePosLastX != 0)
	{
		this.mousePosLastX = this.mousePosX;
	}
	if(!this.mousePosLastY && this.mousePosLastY != 0)
	{
		this.mousePosLastY = this.mousePosY;
	}
	
	//Le delta s'accroît si la souris bouge.
	this.mouseUpDownDelta += Math.floor(Math.sqrt((this.mousePosLastX - e.pageX) * (this.mousePosLastX - e.pageX) + (this.mousePosLastY - e.pageY) * (this.mousePosLastY - e.pageY)));
	
	//On met à jour l'ancienne position de la souris.
	if(this.mousePosLastX != this.mousePosX)
	{
		this.mousePosLastX = this.mousePosX;
	}
	if(this.mousePosLastY != this.mousePosY)
	{
		this.mousePosLastY = this.mousePosY;
	}
	
	//Si la souris a parcouru une trop grande distance, on entre en recherche.
	if(this.mouseUpDownDelta > this.config.mouseUpDownDeltaTreshold)
	{
		//Si on est en mosaique, on entre en filtrage.
		if(this.currentMode == "MOSAIC")
		{
			this.preUnzoom();
			this.currentMode = "FILTER";
			this.isMosaicFiltered = true;
		}
		//Si on est en mode de filtrage, mais qu'on n'est pas en tracé de courbes.
		else if(this.currentMode == "FILTER" && !this.isSearchByCurvesOn && this.isUserInSearchZone)
		{
			//On lance une nouvelle recherche pas courbes.
			this.preUnzoom();
		}
		//Si on est dans une vidéo, on entre en recherche.
		else if(this.currentMode == "VIDEO" || this.currentMode == "TIMELINE")
		{
			this.currentMode = "SEARCH";
		}
		//Si on est en mode recherche dans une vidéo, mais qu'on n'est pas en tracé de courbes.
		/*else if(this.currentMode == "SEARCH" && !this.isSearchByCurvesOn)
		{
			//On lance une nouvelle recherche pas courbes.
		}*/
		
		if(this.currentMode != "NO-USER" && this.currentMode.indexOf("INCOMING") == -1 && !this.isSearchByCurvesOn)
		{
			this.isSearchByCurvesOn = true;
			this.startSearch();
			this.searchCanvas.onPointerIn(this.mousePosX, this.mousePosY - this.MPTop_margin, null, null);
		}
		
		//S'il n'est pas possible d'afficher l'aide.
		if(!this.canNotifyHelp)
		{
			//On rend son affichage possible après un certain délai.
			this.canNotifyHelpTimeout = setTimeout(function()
			{
				_this.canNotifyHelp = true;
			}, this.config.timeoutCanNotifyHelp);
		}
	}
}

/*
 * Fonction appelée lors d'un mouse up en mode d'interaction souris.
 * Est appelé dans le fichier :
 * mosaic > fonction loadMosaic, attachée à l'événement jQuery mousemove.
*/
Mosaic.prototype.onMouseUp = function()
{
	this.isMouseDown = false;
	
	//Si on était en train de tracer une courbe.
	if(this.isSearchByCurvesOn)
	{
		//On quitte la zone de recherche.
		/*this.isUserInSearchZone = false;
		
		//On regarde si ce qu'on a tracé correspond à une courbe en particulier.
		var gesture_match = this.gestureWithSameCode(this.actualCode);
		this.actualCode = '';
		
		//Si oui.
		if(gesture_match.length > 0)
		{
			//Si on est en mode recherche dans une vidéo et que le player est prêt.
			if(this.currentMode == "SEARCH" && this.playerIsReady)
			{
				//On effectue une recherche dans cette vidéo.
				this.player.widgets[0].searchByGesture(gesture_match);
				this.isCurrentlyInASearchByGesture = this.player.widgets[0].isCurrentlyInASearchByGesture;
				
				//On va au premier marqueur trouvé.
				if(this.player && this.player.widgets[0] && this.timeToGoAt[this.centerId] === 0 && this.player.widgets[0].atLeastOneSearchMarker(this.currentSearchGesture[this.centerId]))
				{
					this.player.widgets[0].goToFirstSearchedMarker(this.currentSearchGesture[this.centerId]);
				}
				
				//On affiche la notification de gesture de recherche.
				this.removeNotifications();
				this.currentSearchGesture[this.centerId] = gesture_match;
				this.searchGesture(gesture_match, 'valid');
				this.curvesGesturesFound = false;
			}
			//Si on est en mode de filtrage de mosaique.
			else if(this.currentMode == "FILTER")
			{
				if(this.isMosaicFiltered)
				{
					//On notifie la recherche par filtrage.
					this.removeNotifications();
					this.filterSearchedType = gesture_match;
					this.filterGesture(gesture_match, 'valid');
					//On filtre la mosaique.
					this.searchFilter(gesture_match);
					this.curvesGesturesFound = false;
				}
			}
		}
		//Si aucune gesture ne matche dans le dictionnaire.
		else
		{
			//Si on était en mode filtrage de la mosaïque et qu'aucune gesture de filtrage n'avait été détectée avant ca, on revient en mode mosaïque.
			if(this.currentMode == "FILTER" && this.filterSearchedType == "")
			{
				this.currentMode = "MOSAIC";
				this.isMosaicFiltered = false;
			}
			//Sinon si on était en mode recherche dans une video et qu'aucune gesture n'avait été détectée avant ca, on revient en mode video.
			if(this.currentMode == "SEARCH" && this.currentSearchGesture[this.centerId] == "")
			{
				this.currentMode = "VIDEO";
			}
		}*/
		//On dit au module de recherche qu'on arrête de tracer des courbes.
		this.searchCanvas.onPointerOut();
	}
	
	this.mousePosLastX = null;
	this.mousePosLastY = null;
	
	//Si la distance parcourue par la souris entre le mouse down et le mouse up est inférieure ou égale au seuil.
	if(this.mouseUpDownDelta <= this.config.mouseUpDownDeltaTreshold)
	{
		//Si on est sur un snapshot prézoomé.
		if(this.isOnAPrezoomSN && this.previousZoomedSN != '' && (this.currentMode == 'MOSAIC' || this.currentMode == 'FILTER') && !this.isPrezooming)
		{
			this.zoom();
		}
	}
	
	//On réinitialise le delta, on quitte la recherche par courbes.
	this.mouseUpDownDelta = 0;
	this.isSearchByCurvesOn = false;
	this.leaveSearch();
	
	//Si on est en mode de filtrage et qu'on a une gesture de filtrage trouvée.
	if(this.currentMode == 'FILTER' && this.filterSearchedType != '')
	{
		//On notifie.
		this.removeNotifications();
		this.filterGesture(this.filterSearchedType, 'valid');
	}
}

/*
 * Fonction appelée lors d'un clic en mode d'interaction souris.
 * Est appelé dans le fichier :
 * mosaic > fonction loadMosaic.
*/
Mosaic.prototype.onClick = function(x, y)
{
	//Si la position de la souris entre le mouse down et le mouse up change de plus de 10px, on part.
	if(!this.mouseDownPosX || !this.mouseDownPosY || Math.sqrt((this.mouseDownPosX - x) * (this.mouseDownPosX - x) + (this.mouseDownPosY - y) * (this.mouseDownPosY - y)) > 10)
	{
		return;
	}
	
	//Si on est dans un mode autre qu'un mode zoomé et qu'on n'affiche pas l'aide ou les crédits, on part.
	if(this.currentMode != "VIDEO" && this.currentMode != "SEARCH" && this.currentMode != "TIMELINE" && !this.helpDisplayed && !this.creditsDisplayed)
	{
		return;
	}
	
	//Si on clique en dehors de la video centrale, alors on dézoome.
	var TL = $('.Ldt-Timeline');
	var TLwidth = TL.width(), TLheight = TL.height();
	var Ptop = $('.LdtPlayer').position().top, Pleft = $('.LdtPlayer').position().left;
	var Pheight = $('.LdtPlayer').height();
	var MPx = this.mousePosX, MPy = this.mousePosY;
	
	//On regarde si on a cliqué sur un snapshot.
	var SN = this.pointerPositionToSN(MPx - this.notifyLeftVideo, MPy - this.notifyTopVideo, true);
	var SNId;
	if(SN)
	{
		SNId = parseInt(SN.attr('id').replace('snapshotDiv-', ''));
	}
	
	//Si on n'a pas demandé à supprimé la notification de gesture.
	if(!this.gestureDelRequested && !this.helpDisplayed)
	{
		//Si non, ou s'il ne fait pas partie des voisins.
		if(!SNId || !_.include(this.neighboursIds, SNId))
		{
			//Si le clic a lieu en dehors du player et que l'aide n'est pas affichée, on dezoom.
			if(MPx < Pleft || MPx > (+Pleft + TLwidth) || MPy < Ptop || MPy > (+Ptop + Pheight - TLheight))
			{
				this.unzoom();
			}
		}
		//Si on se trouve sur un voisin, on bouge.
		else if(SNId && _.include(this.neighboursIds, SNId) && this.canMoveToNeighbour)
		{
			this.moveToNeighbour($('#snapshotDiv-' + SNId));
		}
	}
	//Si on l'a demandé, on enlève la demande de suppression.
	else
	{
		this.gestureDelRequested = false;
	}
	
	//Si l'aide est affichée, un clic la ferme.
	if(this.helpDisplayed && !this.isHelpIconZoomed && !this.isHelpIconZooming && !this.isOnHelpArrow(this.mousePosX, this.mousePosY))
	{
		this.removeHelp();
	}
	
	//Si les crédits sont affichés, un clic les ferme.
	if(this.creditsDisplayed && !this.isCreditsIconZoomed && !this.isCreditsIconZooming && !this.isOnCreditsArrow(this.mousePosX, this.mousePosY))
	{
		this.removeCredits();
	}
	
	//Si les crédits sont affichés et qu'on est sur une flèche, on change de page.
	if(this.isOnCreditsUpArrow(this.mousePosX, this.mousePosY))
	{
		this.goToPreviousCreditsPage();
	}
	else if(this.isOnCreditsDownArrow(this.mousePosX, this.mousePosY))
	{
		this.goToNextCreditsPage();
	}
	
	//Si l'aide est affichée et qu'on est sur une flèche, on change de page.
	if(this.isOnHelpUpArrow(this.mousePosX, this.mousePosY))
	{
		this.goToPreviousHelpDetailsPage();
	}
	else if(this.isOnHelpDownArrow(this.mousePosX, this.mousePosY))
	{
		this.goToNextHelpDetailsPage();
	}
}