/*
 * Decompiled with CFR 0.152.
 */
import TUIO.TuioContainer;
import TUIO.TuioCursor;
import TUIO.TuioListener;
import TUIO.TuioObject;
import TUIO.TuioPoint;
import TUIO.TuioTime;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;

public class TuioDemoComponent
extends JComponent
implements TuioListener {
    private Hashtable<Long, TuioDemoObject> objectList = new Hashtable();
    private Hashtable<Long, TuioCursor> cursorList = new Hashtable();
    public static final int finger_size = 15;
    public static final int object_size = 60;
    public static final int table_size = 760;
    public static int width;
    public static int height;
    private float scale = 1.0f;
    public boolean verbose = false;

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        width = n;
        height = n2;
        this.scale = (float)height / 760.0f;
    }

    public void addTuioObject(TuioObject tuioObject) {
        TuioDemoObject tuioDemoObject = new TuioDemoObject(tuioObject);
        this.objectList.put(tuioObject.getSessionID(), tuioDemoObject);
        if (this.verbose) {
            System.out.println("add obj " + tuioObject.getSymbolID() + " (" + tuioObject.getSessionID() + ") " + tuioObject.getX() + " " + tuioObject.getY() + " " + tuioObject.getAngle());
        }
    }

    public void updateTuioObject(TuioObject tuioObject) {
        TuioDemoObject tuioDemoObject = this.objectList.get(tuioObject.getSessionID());
        tuioDemoObject.update(tuioObject);
        if (this.verbose) {
            System.out.println("set obj " + tuioObject.getSymbolID() + " (" + tuioObject.getSessionID() + ") " + tuioObject.getX() + " " + tuioObject.getY() + " " + tuioObject.getAngle() + " " + tuioObject.getMotionSpeed() + " " + tuioObject.getRotationSpeed() + " " + tuioObject.getMotionAccel() + " " + tuioObject.getRotationAccel());
        }
    }

    public void removeTuioObject(TuioObject tuioObject) {
        this.objectList.remove(tuioObject.getSessionID());
        if (this.verbose) {
            System.out.println("del obj " + tuioObject.getSymbolID() + " (" + tuioObject.getSessionID() + ")");
        }
    }

    public void addTuioCursor(TuioCursor tuioCursor) {
        if (!this.cursorList.containsKey(tuioCursor.getSessionID())) {
            this.cursorList.put(tuioCursor.getSessionID(), tuioCursor);
            this.repaint();
        }
        if (this.verbose) {
            System.out.println("add cur " + tuioCursor.getCursorID() + " (" + tuioCursor.getSessionID() + ") " + tuioCursor.getX() + " " + tuioCursor.getY());
        }
    }

    public void updateTuioCursor(TuioCursor tuioCursor) {
        this.repaint();
        if (this.verbose) {
            System.out.println("set cur " + tuioCursor.getCursorID() + " (" + tuioCursor.getSessionID() + ") " + tuioCursor.getX() + " " + tuioCursor.getY() + " " + tuioCursor.getMotionSpeed() + " " + tuioCursor.getMotionAccel());
        }
    }

    public void removeTuioCursor(TuioCursor tuioCursor) {
        this.cursorList.remove(tuioCursor.getSessionID());
        this.repaint();
        if (this.verbose) {
            System.out.println("del cur " + tuioCursor.getCursorID() + " (" + tuioCursor.getSessionID() + ")");
        }
    }

    public void refresh(TuioTime tuioTime) {
        this.repaint();
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, width, height);
        int n = Math.round((float)width - this.scale * 15.0f / 2.0f);
        int n2 = Math.round((float)height - this.scale * 15.0f / 2.0f);
        Enumeration<TuioCursor> enumeration = this.cursorList.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            object2 = enumeration.nextElement();
            if (object2 == null) continue;
            object = ((TuioContainer)object2).getPath();
            TuioPoint tuioPoint = ((Vector)object).elementAt(0);
            if (tuioPoint != null) {
                graphics2D.setPaint(Color.blue);
                for (n3 = 0; n3 < ((Vector)object).size(); ++n3) {
                    TuioPoint tuioPoint2 = (TuioPoint)((Vector)object).elementAt(n3);
                    graphics2D.drawLine(tuioPoint.getScreenX(n), tuioPoint.getScreenY(n2), tuioPoint2.getScreenX(n), tuioPoint2.getScreenY(n2));
                    tuioPoint = tuioPoint2;
                }
            }
            graphics2D.setPaint(Color.lightGray);
            n3 = (int)(this.scale * 15.0f);
            graphics2D.fillOval(tuioPoint.getScreenX(n - n3 / 2), tuioPoint.getScreenY(n2 - n3 / 2), n3, n3);
            graphics2D.setPaint(Color.black);
            graphics2D.drawString(((TuioCursor)object2).getCursorID() + "", tuioPoint.getScreenX(n), tuioPoint.getScreenY(n2));
        }
        object2 = this.objectList.elements();
        while (object2.hasMoreElements()) {
            object = (TuioDemoObject)object2.nextElement();
            if (object == null) continue;
            ((TuioDemoObject)object).paint(graphics2D, width, height);
        }
    }
}

