/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class OSCJavaToByteArrayConverter {
    protected ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private byte[] intBytes = new byte[4];

    public void appendNullCharToAlignStream() {
        int n = this.stream.size() % 4;
        int n2 = 4 - n;
        for (int i = 0; i < n2; ++i) {
            this.stream.write(0);
        }
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public void write(byte[] byArray) {
        this.writeBigEndToFourByteBoundry(byArray);
    }

    public void write(int n) {
        this.writeIntegerToByteArray(n);
    }

    public void write(Float f) {
        this.writeIntegerToByteArray(Float.floatToIntBits(f.floatValue()));
    }

    public void write(Integer n) {
        this.writeIntegerToByteArray(n);
    }

    public void write(String string) {
        this.writeLittleEndToFourByteBoundry(string.getBytes());
    }

    public void write(char c) {
        this.stream.write(c);
    }

    public void write(Object object) {
        if (null == object) {
            return;
        }
        if (object instanceof Float) {
            this.write((Float)object);
            return;
        }
        if (object instanceof String) {
            this.write((String)object);
            return;
        }
        if (object instanceof Integer) {
            this.write((Integer)object);
            return;
        }
    }

    public void writeType(Class clazz) {
        if (Integer.class.equals((Object)clazz)) {
            this.stream.write(105);
            return;
        }
        if (BigInteger.class.equals((Object)clazz)) {
            this.stream.write(104);
            return;
        }
        if (Float.class.equals((Object)clazz)) {
            this.stream.write(102);
            return;
        }
        if (Double.class.equals((Object)clazz)) {
            this.stream.write(100);
            return;
        }
        if (String.class.equals((Object)clazz)) {
            this.stream.write(115);
            return;
        }
        if (Character.class.equals((Object)clazz)) {
            this.stream.write(99);
            return;
        }
    }

    public void writeTypesArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (null == objectArray[i]) continue;
            if (objectArray[i].getClass().isArray()) {
                this.stream.write(91);
                this.writeTypesArray((Object[])objectArray[i]);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(objectArray[i])) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(objectArray[i])) {
                this.stream.write(70);
                continue;
            }
            this.writeType(objectArray[i].getClass());
        }
        this.appendNullCharToAlignStream();
    }

    public void writeTypes(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (null == e) continue;
            if (e.getClass().isArray()) {
                this.stream.write(91);
                this.writeTypesArray((Object[])e);
                this.stream.write(93);
                continue;
            }
            if (Boolean.TRUE.equals(e)) {
                this.stream.write(84);
                continue;
            }
            if (Boolean.FALSE.equals(e)) {
                this.stream.write(70);
                continue;
            }
            this.writeType(e.getClass());
        }
        this.appendNullCharToAlignStream();
    }

    private void writeIntegerToByteArray(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >>>= 8);
        byArray[1] = (byte)(n >>>= 8);
        byArray[0] = (byte)(n >>>= 8);
        try {
            this.stream.write(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeBigEndToFourByteBoundry(byte[] byArray) {
        int n = byArray.length % 4;
        if (n == 0) {
            try {
                this.stream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
            }
            return;
        }
        int n2 = 4 - n;
        byte[] byArray2 = new byte[n2 + byArray.length];
        System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
        try {
            this.stream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }

    private void writeLittleEndToFourByteBoundry(byte[] byArray) {
        int n = byArray.length % 4;
        if (n == 4) {
            try {
                this.stream.write(byArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
            }
            return;
        }
        int n2 = 4 - n;
        byte[] byArray2 = new byte[n2 + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        try {
            this.stream.write(byArray2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("You're screwed: IOException writing to a ByteArrayOutputStream");
        }
    }
}

