/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc;

import com.illposed.osc.OSCPacket;
import com.illposed.osc.utility.OSCJavaToByteArrayConverter;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class OSCBundle
extends OSCPacket {
    protected Date timestamp;
    protected Vector<OSCPacket> packets;
    public static final BigInteger SECONDS_FROM_1900_to_1970 = new BigInteger("2208988800");

    public OSCBundle() {
        this(null, GregorianCalendar.getInstance().getTime());
    }

    public OSCBundle(Date date) {
        this(null, date);
    }

    public OSCBundle(OSCPacket[] oSCPacketArray) {
        this(oSCPacketArray, GregorianCalendar.getInstance().getTime());
    }

    public OSCBundle(OSCPacket[] oSCPacketArray, Date date) {
        if (null != oSCPacketArray) {
            this.packets = new Vector(oSCPacketArray.length);
            for (int i = 0; i < oSCPacketArray.length; ++i) {
                this.packets.add(oSCPacketArray[i]);
            }
        } else {
            this.packets = new Vector();
        }
        this.timestamp = date;
        this.init();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public void addPacket(OSCPacket oSCPacket) {
        this.packets.add(oSCPacket);
    }

    public OSCPacket[] getPackets() {
        OSCPacket[] oSCPacketArray = new OSCPacket[this.packets.size()];
        this.packets.toArray(oSCPacketArray);
        return oSCPacketArray;
    }

    protected void computeTimeTagByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        long l = this.timestamp.getTime();
        long l2 = l / 1000L;
        long l3 = l2 + SECONDS_FROM_1900_to_1970.longValue();
        long l4 = (l - l2 * 1000L) * 1000L;
        oSCJavaToByteArrayConverter.write((int)l3);
        oSCJavaToByteArrayConverter.write((int)l4);
    }

    protected void computeByteArray(OSCJavaToByteArrayConverter oSCJavaToByteArrayConverter) {
        oSCJavaToByteArrayConverter.write("#bundle");
        this.computeTimeTagByteArray(oSCJavaToByteArrayConverter);
        Enumeration<OSCPacket> enumeration = this.packets.elements();
        while (enumeration.hasMoreElements()) {
            OSCPacket oSCPacket = enumeration.nextElement();
            byte[] byArray = oSCPacket.getByteArray();
            oSCJavaToByteArrayConverter.write(byArray.length);
            oSCJavaToByteArrayConverter.write(byArray);
        }
        this.byteArray = oSCJavaToByteArrayConverter.toByteArray();
    }
}

