﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_MIDDLEWARE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Events
 * Classe : ModChangeEventArgs
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Cette classe contient les membres utilisés lors de l'appel au listener correspondant
 * à l'événement : On entre dans un nouveau mode.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Communication;

namespace Trakers.Tracking.Events
{
    public class ModChangeEventArgs : EventArgs
    {
        //Fenêtre de debug.
        public readonly Debug.DebugWindow debug;
        //Serveur TUIO.
        public readonly Server server;
        //Code du mode.
        public readonly String code;

        /*
        * Constructeur : Il prend l'affichage de debug et le serveur TUIO.
        */
        public ModChangeEventArgs(Debug.DebugWindow _debug, Server _server, String _code)
        {
            debug = _debug;
            server = _server;
            code = _code;
        }
    }
}
