/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

class particle
{
    float x;
    float y;
    float xvel;
    float yvel;
    int pos;
    
    particle(float xIn, float yIn)
    {
        x = xIn;
        y = yIn;
    }

    void updatepos()
    {
        float col1;
        if(x > 0 && x < WIDTH && y > 0 && y < HEIGHT)
        {
            //stroke(#cccccc);
            //line(x,y,x+xvel,y+yvel);
            int vi = (int)(x/RES);
            int vu = (int)(y/RES);
            vsquare o = v[vi][vu];
            //xvel += o.xvel*0.05;
            //yvel += o.yvel*0.05;

            float ax = (x%RES)/RES;
            float ay = (y%RES)/RES;

            xvel += (1-ax)*v[vi][vu].xvel*0.05;
            yvel += (1-ay)*v[vi][vu].yvel*0.05;

            xvel += ax*v[vi+1][vu].xvel*0.05;
            yvel += ax*v[vi+1][vu].yvel*0.05;

            xvel += ay*v[vi][vu+1].xvel*0.05;
            yvel += ay*v[vi][vu+1].yvel*0.05;

            o.col += 4;

            x += xvel;
            y += yvel;
        }
        else
        {
            x = random(0,WIDTH);
            y = random(0,HEIGHT);
            xvel = 0;
            yvel = 0;
        }

        xvel *= 0.5;
        yvel *= 0.5;
    }
}
