﻿/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

/*Exemple tiré de processing.org*/

import TUIO.*;
TuioProcessing tuioClient;
int port = 80;
//Taille de la fenêtre
int WIDTH = 640, HEIGHT = 480;

float minDistHands = 1, maxDistHands = 1.5;
//Distance de "click" minimum/maximum avec la main.
float minClickHand = minDistHands+0.2, maxClickHand = maxDistHands-0.2;
//Définit les coordonnées de la main la plus proche et si elle a cliqué (se trouve dans une certaine zone du champ d'intéraction).
int X, Y;
boolean clicked;

int[] xvals;
int[] yvals;
int[] bvals;

void setup() 
{
  size(WIDTH, HEIGHT);
  tuioClient = new TuioProcessing(this, port);
  xvals = new int[width];
  yvals = new int[width];
  bvals = new int[width];
}

int arrayindex = 0;

void draw()
{
  tuioInput();
  background(102);
  
  for(int i=1; i<width; i++) { 
    xvals[i-1] = xvals[i]; 
    yvals[i-1] = yvals[i];
    bvals[i-1] = bvals[i];
  } 
  // Add the new values to the end of the array 
  xvals[width-1] = X; 
  yvals[width-1] = Y;
  if(clicked) {
    bvals[width-1] = 0;
  } else {
    bvals[width-1] = 255;
  }
  
  fill(255);
  noStroke();
  rect(0, height/3, width, height/3+1);

  for(int i=1; i<width; i++) {
    stroke(255);
    point(i, xvals[i]/3);
    stroke(0);
    point(i, height/3+yvals[i]/3);
    stroke(255);
    line(i, 2*height/3+bvals[i]/3, i, (2*height/3+bvals[i-1]/3));
  }
}

/*MET A JOUR X et Y
Entrée : Les positions d'un point 2D
Sortie : Met à jour X et Y et si la main a "clické"*/
void update(int x, int y, boolean click)
{
  X = x;
  Y = y;
  clicked = click;
}
