﻿/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE_FRONT
* file that was distributed with this source code.
*/

class vsquare
{
    int x;
    int y;
    float xvel;
    float yvel;
    float col;

    vsquare(int xIn,int yIn)
    {
        x = xIn;
        y = yIn;
    }

    void addbuffer(int i, int u)
    {
        if(i>0 && i<lwidth && u>0 && u<lheight)
        {
            xvel += (vbuf[i-1][u-1].pressure*0.5
            +vbuf[i-1][u].pressure
            +vbuf[i-1][u+1].pressure*0.5
            -vbuf[i+1][u-1].pressure*0.5
            -vbuf[i+1][u].pressure
            -vbuf[i+1][u+1].pressure*0.5
            )*0.25;
            yvel += (vbuf[i-1][u-1].pressure*0.5
            +vbuf[i][u-1].pressure
            +vbuf[i+1][u-1].pressure*0.5
            -vbuf[i-1][u+1].pressure*0.5
            -vbuf[i][u+1].pressure
            -vbuf[i+1][u+1].pressure*0.5
            )*0.25;
        }
    }

    void updatevels(int mvelX, int mvelY, TuioPoint pt)
    {
        if(pt != null)
        {
            float adj = x - pt.getX();
            float opp = y - pt.getY();
            float dist = sqrt(opp*opp + adj*adj);
            if(dist < PENSIZE)
            {
                if(dist < 4) dist = PENSIZE;
                float mod = PENSIZE/dist;
                xvel += mvelX*mod;
                yvel += mvelY*mod;
            }
        }
    
        xvel *= 0.99;
        yvel *= 0.99;
    }

    void display(int i, int u)
    {
        float tcol = 0;
        if(col > 255) col = 255;
        if(i>0 && i<lwidth-1 && u>0 && u<lheight-1)
        {
            tcol = (+ v[i][u+1].col + v[i+1][u].col + v[i+1][u+1].col*0.5)*0.4;
            tcol = (int)(tcol+col*0.5);
        }
        else
        {
            tcol = (int)col;
        }
        fill(tcol, tcol, tcol);
        rect(x,y,RES,RES);
        //col = 32;
    }
}
