﻿/*
Added by alexandre.bastien@iri.centrepompidou.fr
*/

package TUIO;

/**
 * The TuioCursor class encapsulates /tuio/_siP TUIO strings.
 *
 */ 
public class TuioString {

    /**
     * The unique session ID number that is assigned to each TUIO string.
     */ 
    protected long session_id;

    /**
     * The individual string ID number that is assigned to each TuioString.
     */ 
    protected int string_id;
    
    /**
     * The individual string message that is assigned to each TuioString.
     */ 
    protected String message;
    
    /**
     * The time stamp of the last update represented as TuioTime (time since session start)
     */
    protected TuioTime currentTime;
    /**
     * The creation time of this TuioString represented as TuioTime (time since session start)
     */
    protected TuioTime startTime;
    
    /**
     * Defines the ADDED state.
     */ 
    public static final int TUIO_ADDED = 0;
    /**
     * Defines the REMOVED state.
     */ 
    public static final int TUIO_REMOVED = 4;
    /**
     * Reflects the current state of the TuioString
     */ 
    protected int state;
    
    /**
     * This constructor takes a TuioTime argument and assigns it along  with the provided 
     * Session ID, String ID and a message to the newly created TuioString.
     *
     * @param    ttime    the TuioTime to assign
     * @param    si    the Session ID  to assign
     * @param    sti    the String ID  to assign
     * @param    msg the message to assign
     */
    public TuioString (TuioTime ttime, long si, int sti, String msg) {
        this.session_id = si;
        this.string_id = sti;
        this.message = msg;
        currentTime = new TuioTime(ttime);
        startTime = new TuioTime(currentTime);
    }
    
    /**
     * This constructor takes the provided Session ID, String ID and message 
     * and assigs these values to the newly created TuioString.
     *
     * @param    si    the Session ID  to assign
     * @param    sti    the String ID  to assign
     * @param    msg    the message to assign
     */
    public TuioString (long si, int sti, String msg) {
        this.session_id = si;
        this.string_id = sti;
        this.message = msg;
        currentTime = TuioTime.getSessionTime();
        startTime = new TuioTime(currentTime);
    }
    
    /**
     * This constructor takes the atttibutes of the provided TuioCursor 
     * and assigs these values to the newly created TuioCursor.
     *
     * @param    tcur    the TuioCursor to assign
     */
    public TuioString (TuioString tstr) {
        this.session_id = tstr.getSessionID();
        this.string_id = tstr.getStringID();
        this.message = tstr.getMessage();
        currentTime = new TuioTime(tstr.getCurrentTime());
        startTime = new TuioTime(currentTime);
    }

    /**
     * Takes a TuioTime argument and assigns it along with the provided 
     * message to the private TuioString attributes.
     * The speed and accleration values are calculated accordingly.
     *
     * @param    ttime    the TuioTime to assign
     * @param    message2 the message to assign
     */
    public void update(TuioTime ttime, String message2) {
        currentTime = new TuioTime(ttime);
        message = message2;
    }
    
    /**
     * This method is used to update the TuioTime of a TuioString while keeping the same * * * message.
     */
    public void stop(TuioTime ttime) {
        update(ttime,message);
    }
    
    /**
     * Takes the atttibutes of the provided TuioString 
     * and assigs these values to this TuioString.
     * The TuioTime time stamp of this TuioString remains unchanged.
     *
     * @param    tstr    the TuioString to assign
     */
    public void update (TuioString tstr) {
        message = tstr.getMessage();
    }
    
    /**
     * Takes the message provided
     * and assigs its value to this TuioString.
     * The TuioTime time stamp of this TuioString remains unchanged.
     *
     * @param    msg    the message to assign
     */
    public void update (String msg) {
        message = msg;
    }
    
    /**
     * Assigns the REMOVE state to this TuioString and sets
     * its TuioTime time stamp to the provided TuioTime argument.
     *
     * @param    ttime    the TuioTime to assign
     */
    public void remove(TuioTime ttime) {
        currentTime = new TuioTime(ttime);
        state = TUIO_REMOVED;
    }
    
    /**
     * Returns the Session ID of this TuioString.
     * @return    the Session ID of this TuioString
     */
    public long getSessionID() {
        return session_id;
    }
    
    /**
     * Returns the String ID of this TuioString.
     * @return    the String ID of this TuioString
     */
    public int getStringID() {
        return string_id;
    }
    
    /**
     * Returns the Message of this TuioString.
     * @return    the Message of this TuioString
     */
    public String getMessage() {
        return message;
    }
    
    /**
     * Returns the Current Time of this TuioString.
     * @return    the Current Time of this TuioString
     */
    public TuioTime getCurrentTime() {
        return currentTime;
    }
    
    /**
     * Returns the TUIO state of this TuioString.
     * @return    the TUIO state of this TuioString
     */
    public int getTuioState() {
        return state;
    }
}
