/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : MainModule/Events
 * Classe : PushListener
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Ce listener écoute l'événement du type : L'utilisateur a effectué un push.
 * Il contient le code a être éxecuté au cas où cet événement survient.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Trakers.Tracking.Gestures;

namespace Trakers.MainModule.Events
{
    public class PushListener
    {
        /*
        * Méthode appelée lorsque on a l'événement : L'utilisateur a effectué un push.
        */
        public void showAndSend(object o, PushEventArgs e)
        {
            //On l'indique dans le debug.
            //Lorsqu'il s'agit d'un push/pull de la main gauche/droite/deux deux on envoie le message
            //correspondant.
            String code = "";
            if (e.direction == PushDetector.Direction.PUSH)
            {
                if (e.hand == PushDetector.Hand.RIGHT)
                    code = "PUSH-RIGHT";
                else if (e.hand == PushDetector.Hand.LEFT)
                    code = "PUSH-LEFT";
                else
                    code = "PUSH-BOTH";
            }
            else
            {
                if (e.hand == PushDetector.Hand.RIGHT)
                    code = "PULL-RIGHT";
                else if (e.hand == PushDetector.Hand.LEFT)
                    code = "PULL-LEFT";
                else
                    code = "PULL-BOTH";
            }
            
            e.debug.showGesture(code);
            e.server.GesturePerformed(code);
        }
    }
}
