
/*
 * Déclaration du canvas de recherche par courbes.
*/
function searchCanvas(_canvasTop, _canvasLeft, _canvasWidth, _canvasHeight, _margin_top, _fadeTime, _inMosaic, _mosaic)
{
	//Coordonnées, dimensions et autres paramètres du canvas.
	this.canvasTop = _canvasTop;
	this.canvasLeft = _canvasLeft;
	this.canvasWidth = _canvasWidth;
	this.canvasHeight = _canvasHeight;
	this.fadeTime = _fadeTime;
	this.margin_top = _margin_top;
	
	this.mosaic = _mosaic;
	
	//Courbe du pointeur principal.
	this.mainPath;
	this.mainPathStroke;
	
	//Courbe du pointeur secondaire.
	this.secondPath;
	this.secondPathStroke;
	
	//Courbe indicatrice de la direction actuelle.
	this.direction;
	
	//Point précédent des pointeurs.
	this.mainLastPoint;
	this.secondLastPoint;
	
	//Coordonnées précédentes des pointeurs.
	this.mainPointerLastX;
	this.mainPointerLastY;
	this.secondPointerLastX;
	this.secondPointerLastY;
	
	this.inMosaic = _inMosaic;
	
	this.detector;
}

/*
 * Fonction d'initialisation du canvas de recherche par courbes.
*/
searchCanvas.prototype.create = function(dictionary)
{
	var _this = this;
	
	//On crée le canvas.
	var canvas = '<canvas id="paperCanvas" width="' + this.canvasWidth + 'px" height="' + this.canvasHeight + 'px" class="canvas"></canvas>';
	//On l'ajoute à la page.
	$('body').append(canvas);
	
	$('.canvas').css(
	{
		top: this.canvasTop,
		left: this.canvasLeft
	});
	
	//S'il est dans la mosaique, on le réhausse en fonction de la taille de la marge verticale.
	if(this.inMosaic)
	{
		console.log(this.margin_top);
		$('.canvas').css(
		{
			"margin-top": this.margin_top
		});
	}
	
	//On instancie le détecteur de courbes de recherche.
	this.detector = new curvesDetector(6, 100, dictionary, this.mosaic);
	
	//On active le canvas.
	paper.setup('paperCanvas');
};

/*
 * Fonction appelée pour quitter le mode de recherche par courbes.
*/
searchCanvas.prototype.leaveSearch = function()
{
	$('.canvas').fadeTo(this.fadeTime, 0, function()
	{
		$('.canvas').remove();
	});
};

/*
 * Fonction de déclaration des courbes.
*/
searchCanvas.prototype.onPointerIn = function(mainPointerX, mainPointerY, secondPointerX, secondPointerY)
{
	//On obtient les coordonnées du pointeur principal en px.
	mainPointerX = Math.floor(mainPointerX);
	mainPointerY = Math.floor(mainPointerY);
	
	//On forme le contour la courbe principale.
	this.mainPathStroke = new paper.Path();
	this.mainPathStroke.strokeColor = '#366F7A';
	this.mainPathStroke.strokeWidth = 18;
	this.mainPathStroke.strokeCap = 'round';
	this.mainPathStroke.strokeJoin = 'round';
	
	//On forme la courbe principale.
	this.mainPath = new paper.Path();
	this.mainPath.strokeColor = '#02FEFF';
	this.mainPath.strokeWidth = 10;
	this.mainPath.strokeCap = 'round';
	this.mainPath.strokeJoin = 'round';
	
	this.direction = new paper.Path();
	this.direction.strokeColor = '#FF0000';
	this.direction.strokeWidth = 5;
	this.direction.strokeCap = 'round';
	this.direction.strokeJoin = 'round';
	
	//Si on a un pointeur secondaire
	if(secondPointerX && secondPointerY)
	{
		//On obtient les coordonnées du pointeur secondaire en px.
		secondPointerX = Math.floor(secondPointerX);
		secondPointerY = Math.floor(secondPointerY);
		
		//On forme le contour de la courbe secondaire.
		this.secondPathStroke = new paper.Path();
		this.secondPathStroke.fillColor = '#366F7A';
		this.secondPathStroke.strokeWidth = 12;
		this.secondPathStroke.strokeCap = 'round';
		this.secondPathStroke.strokeJoin = 'round';
		
		//On forme la courbe secondaire.
		this.secondPath = new paper.Path();
		this.secondPath.fillColor = '#02FEFF';
		this.secondPath.strokeWidth = 10;
		this.secondPath.strokeCap = 'round';
		this.secondPath.strokeJoin = 'round';
	}
	
	// console.log('IN');
	
	//On raffraichit l'affichage.
	paper.view.draw();
};

/*
 * Fonction appelée lorsque les pointeurs bougent pour construire la courbe.
*/
searchCanvas.prototype.onPointerMove = function(mainPointerX, mainPointerY, secondPointerX, secondPointerY)
{
	// console.log('MOVE');
	
	if(!this.mainPointerLastX || !this.mainPointerLastY)
	{
		this.mainPointerLastX = mainPointerX;
		this.mainPointerLastY = mainPointerY;
	}
	
	//On obtient les coordonnées du pointeur principal en px.
	mainPointerX = Math.floor(mainPointerX);
	mainPointerY = Math.floor(mainPointerY);
	
	//On crée les points de la courbe principale.
	var mainPoint = new paper.Point(mainPointerX, mainPointerY);
	var mainPointStroke = new paper.Point(mainPointerX, mainPointerY);
	
	//On les ajoute à la courbe.
	this.mainPathStroke.add(mainPointStroke);
	this.mainPathStroke.smooth();
	
	this.mainPath.add(mainPoint);
	this.mainPath.smooth();
	
	//this.direction.remove();
	// console.log(this.mainPointerLastX, this.mainPointerLastY);
	var directionPoint = new paper.Point(this.mainPointerLastX, this.mainPointerLastY);
	var directionPointEnd = new paper.Point((mainPointerX - this.mainPointerLastX) * 2 + mainPointerX, (mainPointerY - this.mainPointerLastY) * 2 + mainPointerY);
	this.direction.add(directionPoint);
	this.direction.add(directionPointEnd);
	this.direction.smooth();
	
	//Variables de construction de la courbe secondaire.
	var secondPoint, secondDelta, secondStep, secondStepStroke, secondTop, secondBottom, secondTopStroke, secondBottomStroke;
	
	//Si on a un pointeur secondaire.
	if(secondPointerX && secondPointerY)
	{
		//On obtient les coordonnées du pointeur secondaire en px.
		secondPointerX = Math.floor(secondPointerX);
		secondPointerY = Math.floor(secondPointerY);
		
		//On crée les points de la courbe secondaire.
		secondPoint = new paper.Point(mainPointerX, mainPointerY);
		secondPointStroke = new paper.Point(mainPointerX, mainPointerY);
		
		//On les ajoute à la courbe.
		this.secondPathStroke.add(secondPointStroke);
		this.secondPathStroke.smooth();
		
		this.secondPath.add(secondPoint);
		this.secondPath.smooth();
	}
	
	if(this.mainPointerLastX != mainPointerX)
	{
		this.mainPointerLastX = mainPointerX;
	}
	if(this.mainPointerLastY != mainPointerY)
	{
		this.mainPointerLastY = mainPointerY;
	}
	
	//On met à jour les points dans le détecteur de courbes.
	this.detector.updatePos(mainPointerX, mainPointerY);
	
	//On met à jour l'affichage.
	paper.view.draw();
};

/*
 * Fonction appelée lorsqu'on cesse de dessiner une courbe.
*/
searchCanvas.prototype.onPointerOut = function()
{
	// console.log('OUT');
	
	//On réinitialise la courbe principale.
	this.mainPathStroke.remove();
	this.mainPath.remove();
	
	this.mainPointerLastX = 0;
	this.mainPointerLastY = 0;
	
	this.direction.remove();
	
	this.detector.reinit();
	
	//Si on a un second pointeur, on réinitialise la courbe secondaire.
	if(this.secondPathStroke)
	{
		this.secondPathStroke.remove();
	}
	if(this.secondPath)
	{
		this.secondPath.remove();
	}
	
	//On met à jour l'affichage.
	paper.view.draw();
};

searchCanvas.prototype.onKeyDown = function(event)
{
	//S'il n'y a rien a colorier, on quitte.
	if(typeof this.pathStroke === 'undefined' || typeof this.path === 'undefined')
		return;
	
	if(event.key == 'r' || event.key == 'R')
	{
		this.pathStroke.fillColor = '#49564F';
		this.path.fillColor = '#00FE00'
	}
	else if(event.key == 'x' || event.key == 'X')
	{
		this.pathStroke.fillColor = '#535F6D';
		this.path.fillColor = '#CCCCCC'
	}
	else if(event.key == 'w' || event.key == 'W')
	{
		this.pathStroke.fillColor = '#366F7A';
		this.path.fillColor = '#02FEFF'
	}
};