/*
* This file is part of the TraKERS\Front JS package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : Front JS
 * Fichier : gestures.js
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Définit la "classe" de gestion des gestes et définit des fonctions d'intéraction.
 */

/*
 * Classe définissant les gestes.
 */
function gestures(config)
{
    this.isGestureShown = false;
    this.showGestureTimeout;
    
    this.imgWidth;
    this.imgHeight;
    
    this.config = config;
    
    var textPanel = "<div id='textPanel'>Aucune gesture n'est détectée.</div>";
    var imagePanel = "<img id='imagePanel' src='./img/black.png'></img>";
    $('body').append(textPanel + imagePanel);
    
    $('#imagePanel').load(function()
    {
        this.imgWidth = $('#imagePanel').width();
        this.imgHeight = $('#imagePanel').height();
        
        //On positionne l'image au centre de l'écran.
        $('#imagePanel').css(
        {
            top: ($(window).height() - this.imgWidth) / 2,
            left: ($(window).width() - this.imgHeight) / 2
        });
    });
    
    this.wsClient = new client(this.config["host"], this.config["port"], this);
}

/*
 * Affiche les gestures reçues.
*/
gestures.prototype.showGesture = function(gesture)
{
    //Si on n'avait aucune gesture, on peut l'afficher.
    if(!this.isGestureShown)
    {
        var _this = this;
        
        this.isGestureShown = true;
        $('#textPanel').html("Gesture de code " + gesture + " détectée.");
        //On retrouve le nom du fichier image correspondant dans le code de la gesture.
        gesture = gesture.toLowerCase().replace('-', '_');
        $('#imagePanel').attr("src", "./img/" + gesture + ".png");
        
        //On supprime l'affichage au bout de N ms.
        this.showGestureTimeout = setTimeout(function()
        {
            _this.isGestureShown = false;
            $('#imagePanel').attr("src", "./img/black.png");
            $('#textPanel').html("Aucune gesture n'est détectée.");
        }, this.config["timeShowGesture"]);
    }
}