﻿/*
* This file is part of the TraKERS\Middleware package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

/*
 * Projet : TraKERS
 * Module : MIDDLEWARE
 * Sous-Module : Tracking/Gestures
 * Classe : JumpDetector
 * 
 * Auteur : alexandre.bastien@iri.centrepompidou.fr
 * 
 * Fonctionnalités : Permet de détecter si l'utilisateur a sauté, en se basant sur
 * des règles appliquées à la positions des noeuds dans le temps.
 * 
 * P.S : Cette partie est encore en développement.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Kinect;
using Trakers.Debug;

namespace Trakers.Tracking.Gestures
{
    public class JumpDetector : GestureDetector
    {
        static int n = 0;

        public JumpDetector(DebugWindow _debug) : base(_debug)
        {
            gesturePeriod = (float)1.5;
            indexesPerSecond = 30;
            indexesToCheck = (int)(gesturePeriod * indexesPerSecond);
        }

        /*
         * Lit les noeuds de l'historique du squelette afin de détecter un Jump.
         * Règles :
         * .
         */
        public bool CheckForJump()
        {
            //Crée un historique de squelette local, puisque l'historique est mis à jour toutes les ~1/30 s.
            List<List<Joint>> localHistory = new List<List<Joint>>(history);
            
            //Si il n'y a pas assez de positions dans l'historique local pour vérifier le geste.
            if (localHistory.Count < indexesToCheck)
                return false;

            /* (HeadBelowBaseLine || LeftKneeBelowBaseLine || RightKneeBelowBaseLine ||
             * LeftAnkleBelowBaseLine || RightAnkleBelowBaseLine || BodyFaceUpwards
             * 
             * NOT
             * 
             * AND
             * 
             * HeadAboveBaseLine && LeftKneeAboveBaseLine && RightKneeAboveBaseLine &&
             * LegsStraightPreviouslyBent)
             * 
             * OR
             * 
             * HeadFarAboveBaseLine
             */

            //La distance de référence est ici la distance entre les épaules et les hanches.
            refDistance = Math.Abs(localHistory[0][(int)JointType.ShoulderCenter].Position.Y - localHistory[0][(int)JointType.HipCenter].Position.Y);
            //On commence la position pour les indexesToCheck dernières postures (celle à l'index 0 étant la dernière).

            int beginIdx = localHistory.Count - indexesToCheck + 1;

            int middleIdx = 0;
            int endIdx = 0;
            bool topOfJump = false;
            bool probableJump = false;

            //De la position p1 à pn, on suit l'algorithme.
            for (int i = beginIdx ; i < localHistory.Count ; i++)
            {
                if (localHistory[i][(int)JointType.Spine].Position.Y + refDistance / 2 < localHistory[beginIdx][(int)JointType.Spine].Position.Y)
                {
                    topOfJump = true;
                    middleIdx = i;
                    debug.onR0(true);
                }

                if (localHistory[i][(int)JointType.HandRight].Position.Y > localHistory[beginIdx][(int)JointType.Spine].Position.Y)
                {
                    debug.onR0(false);
                    debug.onR1(false);
                    debug.onR2(false);
                }
            }

            if (topOfJump)
            {
                for (int i = middleIdx; i < localHistory.Count; i++)
                {
                    if (Math.Abs(localHistory[beginIdx][(int)JointType.Spine].Position.Y - localHistory[i][(int)JointType.Spine].Position.Y) < refDistance / 5 ||
                        localHistory[beginIdx][(int)JointType.Spine].Position.Y < localHistory[i][(int)JointType.Spine].Position.Y)
                    {
                        probableJump = true;
                        endIdx = i;
                        debug.onR1(true);
                        //Console.Out.WriteLine("TOP");
                    }
                }
            }
            else
            {
                debug.onR0(false);
                debug.onR1(false);
                debug.onR2(false);
                return false;
            }

            if (probableJump)
            {
                if (Math.Abs(localHistory[beginIdx][(int)JointType.Spine].Position.Z - localHistory[endIdx][(int)JointType.Spine].Position.Z) < 0.10)
                {
                    debug.onR2(true);
                    return true;
                }
            }
            else
            {
                debug.onR0(false);
                debug.onR1(false);
                debug.onR2(false);
                return false;
            }
                
                //if (localHistory[i - 1][(int)JointType.HandRight].Position.Y > localHistory[i][(int)JointType.HandRight].Position.Y && !topOfJump)
                    //return false;

                //Si la position Y de la main est plus haute que la tête
                //OU si la position Y de la main est plus basse que la hanche
                //OU si la nouvelle position Z de la main est moins profonde que la précédente
                //OU si la nouvelle position X de la main est plus éloignée de la distance N par rapport à la première position X
                //OU si la nouvelle position Y de la main est plus éloignée de la distance N par rapport à la première position Y
                //Alors la main en question ne fait pas de push.
                /*if (localHistory[i - 1][(int)JointType.HandRight].Position.Y > localHistory[i][(int)JointType.HandRight].Position.Y &&
                    topOfJump || localHistory[i - 1][(int)JointType.HandRight].Position.Y < localHistory[i][(int)JointType.HandRight].Position.Y &&
                    !topOfJump)
                    return false;*/
            //}

            //Console.Out.WriteLine("OK");

            //Si la distance en Z du geste a été plus courte que la distance N
            //Alors on retourne faux.
            //float dist = (localHistory[localHistory.Count - 1][handRightID].Position.X - localHistory[localHistory.Count - indexesToCheck][handRightID].Position.X);

            //Console.WriteLine(Math.Abs(localHistory[0][handLeftID].Position.Z - localHistory[localHistory.Count - indexesToCheck][handLeftID].Position.Z) * 100 + " " + refDistance);

            //Si la dernière position de la main droite/gauche est sur le côté gauche/droit du corps
            //OU si la première position calculée de la main droite/gauche est sur le côté gauche/droit du corps
            //Alors on retourne faux.
            
            //On supprime l'historique local.
            
            return false;
        }
    }
}
