/*
* This file is part of the TraKERS\Front Processing package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

class vsquare {
  int x;
  int y;
  float xvel;
  float yvel;
  float col;
  
  vsquare(int xIn,int yIn) {
    x = xIn;
    y = yIn;
  }
  
  void addbuffer(int i, int u) {
    if(i>0 && i<lwidth && u>0 && u<lheight) {
      xvel += (vbuf[i-1][u-1].pressure*0.5
      +vbuf[i-1][u].pressure
      +vbuf[i-1][u+1].pressure*0.5
      -vbuf[i+1][u-1].pressure*0.5
      -vbuf[i+1][u].pressure
      -vbuf[i+1][u+1].pressure*0.5
      )*0.49;
      yvel += (vbuf[i-1][u-1].pressure*0.5
      +vbuf[i][u-1].pressure
      +vbuf[i+1][u-1].pressure*0.5
      -vbuf[i-1][u+1].pressure*0.5
      -vbuf[i][u+1].pressure
      -vbuf[i+1][u+1].pressure*0.5
      )*0.49;
    }
  }
  
  void updatevels(int mvelX, int mvelY, TuioPoint pt) {
    float adj = x;
    float opp = y;
    float dist;
    float mod;
    
    if(pt != null) {
      float XRev = map(pt.getX(), realWidth, realHeight, WIDTH, HEIGHT);
      float YRev = map(pt.getY(), realWidth, realHeight, WIDTH, HEIGHT);
      adj = x - XRev;
      opp = y - YRev;
      dist = sqrt(opp*opp + adj*adj);
      if(dist < PENSIZE) {
        if(dist < 4) dist = PENSIZE;
        mod = PENSIZE/dist;
        xvel += mvelX*mod;
        yvel += mvelY*mod;
      }
    }
    if(randomGust > 0) {
      adj = x - randomGustX;
      opp = y - randomGustY;
      dist = sqrt(opp*opp + adj*adj);
      if(dist < randomGustSize) {
        if(dist < RES*2) dist = randomGustSize;
        mod = randomGustSize/dist;
        xvel += (randomGustMax-randomGust)*randomGustXvel*mod;
        yvel += (randomGustMax-randomGust)*randomGustYvel*mod;
      }
    }
    xvel *= 0.99;
    yvel *= 0.98;
  }
  
  void addcolour(int amt) {
    col += amt;
    if(col > 196) col = 196;
  }
  
  void display(int i, int u) {
    float tcol = 0;
    if(i>0 && i<lwidth-1 && u>0 && u<lheight-1) {
      tcol = (+ v[i][u+1].col
      + v[i+1][u].col
      + v[i+1][u+1].col*0.5
      )*0.3;
      tcol = (int)(tcol+col*0.5);
    }
    
    fill(255-tcol, 255-tcol, 255-tcol);
    rect(x,y,RES,RES);
    col = 0;
  }
}
