"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.conf import settings
from django.utils._os import WindowsError
from ldt.ldt_utils.models import User, Content, Media
from ldt.test.client import Client
from ldt.test.testcases import TestCase
import logging
import os

class ContentTest(TestCase):
    
    fixtures = ['base_data.json', 'user_data.json']
    
    def setUp(self):
        self.client = Client()
        User.objects.create_superuser('blop', 'blop@blop.com', 'blop')
        
        _ = self.client.login(username='blop', password='blop')
        
        self.user = User()
        self.user.username = 'blop'
        
    #test the creation of a content without media
    def test_create_content_v1(self):
        self.cont12 = Content(iriurl="id12/iriurl12", duration = 100)
        self.cont12.iri_id = "id112"
        self.cont12.save()
        
        self.assertEqual(Content.objects.get(iri_id=self.cont12.iri_id), self.cont12)
        
    #test the creation of a content with a media
    def test_create_content_v2(self):
        self.media13 = Media()
        self.cont13 = Content(iriurl="id13/iriurl13", duration = 100, media_obj = self.media13)
        self.cont13 = Content(iriurl="id13/iriurl13", duration = 100)
        self.cont13.iri_id = "id113"
        self.cont13.save()
        
        self.assertEqual(Content.objects.get(iri_id=self.cont13.iri_id), self.cont13)

    #test the creation of content without reading permission
    def test_create_content_v3(self):
        import sys
        ldt_dir = os.path.join(settings.MEDIA_ROOT, "ldt")
        if sys.platform == 'win32':
            logging.debug("windows 3")
        else:
            logging.debug("linux")
            os.chmod(ldt_dir, 0577)
            
            self.cont17 = Content(iriurl="id17/iriurl17", duration = 100)
            self.cont17.iri_id = 'id117'
            with self.assertRaises(WindowsError):
                self.cont17.save()
            with self.assertRaises(Content.DoesNotExist):
                Content.objects.get(iri_id=self.cont17.iri_id)
            
        if sys.platform == 'win32':
            logging.debug("windows 4")
        else:
            logging.debug("linux")
            os.chmod(ldt_dir, 0700)
            
        #test the creation of content without reading permission
    def test_create_content_v4(self):
        import sys
        ldt_dir = os.path.join(settings.MEDIA_ROOT, "ldt")
        if sys.platform == 'win32':
            logging.debug("windows 3")
        else:
            logging.debug("linux")
            os.chmod(ldt_dir, 0377)
            
            self.cont18 = Content(iriurl="id18/iriurl18", duration = 100)
            self.cont18.iri_id = 'id118'
            with self.assertRaises(WindowsError):
                self.cont18.save()    
            with self.assertRaises(Content.DoesNotExist):
                Content.objects.get(iri_id=self.cont18.iri_id)
            
        if sys.platform == 'win32':
            logging.debug("windows 4")
        else:
            logging.debug("linux")
            os.chmod(ldt_dir, 0700)  
         
    #test the deletion of a content without media
    def test_del_content_v1(self):
        self.cont14 = Content(iriurl="id14/iriurl14", duration = 100)
        self.cont14.iri_id = "id114"
        self.cont14.save()

        self.cont14.delete()
        self.cont14.commit()
        
        with self.assertRaises(Content.DoesNotExist):
            Content.objects.get(iri_id=self.cont14.iri_id)
        
    #test the deletion of a content with media
    def test_del_content_v2(self):
        self.media15 = Media()
        self.cont15 = Content(iriurl="id15/iriurl15", duration = 100, media_obj = self.media15)
        self.cont15.iri_id = "id115"
        self.cont15.save()
        
        self.cont15.delete()
        self.cont15.commit()
    
        with self.assertRaises(Content.DoesNotExist):
            Content.objects.get(iri_id=self.cont15.iri_id)
        