function IncPlayer()
{
	// --------------------------------------------------------------------------------------------------------------------
	// Members
	// --------------------------------------------------------------------------------------------------------------------

	// Global
	this.initDone = false;
	this.playerIsReady = false;
	this.iOS = false;

	// Sequences
	this.allSequencesData = [];
	this.sequences = [];

	// Popcorn objects
	this.videoDivId = "";
	this.videoExt = "";
	this.preferOgg = true; // debug
	this.popSeq = null;

	// Controls
	this.playButton = null;
	this.progressCurrent = null;
	this.progressDuration = null;
	this.hd = false;
	this.seekTime = 0.0;

	// Tools
	this.logiEnable = true;
	this.jsonData = [];

	// --------------------------------------------------------------------------------------------------------------------
	// Functions
	// --------------------------------------------------------------------------------------------------------------------

	this.init = function(videoDivId, playButtonId, progressCurrentId, progressDurationId, jsonFile, preferOgg)
	{
		this.videoDivId = videoDivId;
		this.preferOgg = preferOgg;

		// Control
		this.playButton = $("#" + playButtonId).get(0);
		this.progressCurrent = $("#" + progressCurrentId);
		this.progressDuration = $("#" + progressDurationId);

		// Video extention
		this.videoExt = this.getSupportedVideoExt();
		if (this.videoExt === "") {
			this.loge("your browser don't support HTML5 videos");
			return false;
		}

		// Detect iOS
		this.detectIOS();
		if (this.iOS) {
			this.logi("we are on iOS");
		}

		// Load all sequences data
		this.allSequencesData = this.loadJson(jsonFile);
		this.logi("sequences in part1: " + (this.allSequencesData.part1 !== undefined ? this.allSequencesData.part1.length : 0));
		this.logi("sequences in part2: " + (this.allSequencesData.part2 !== undefined ? this.allSequencesData.part2.length : 0));
		this.logi("sequences in part3: " + (this.allSequencesData.part3 !== undefined ? this.allSequencesData.part3.length : 0));

		this.initDone = true;
		return true;
	};

	this.destroySequence = function()
	{
		if (this.popSeq !== null) {
			for (var i = 0; i < this.sequences.length; ++i) {			
				this.popSeq.eq(i).destroy();			
			}
			this.sequences = [];
			this.popSeq.remove();
		}		
	};

	this.createPopSequence = function()
	{
		if (!this.initDone) {
			this.loge("incplayer not initialized");
			return;
		}

		// Delete previous popcorn objects
		this.destroySequence();

		// Choose the 3 video
		this.choosePopSequence();

		// And cerate the popcorn sequence
		this.initPopSequence();
	};

	this.choosePopSequence = function()
	{
		this.sequences = [];
		if (this.allSequencesData.part1 !== undefined && this.allSequencesData.part1.length) {
			this.sequences.push(this.allSequencesData.part1[this.random(0, this.allSequencesData.part1.length)]);			
		}
		if (this.allSequencesData.part2 !== undefined && this.allSequencesData.part2.length) {
			this.sequences.push(this.allSequencesData.part2[this.random(0, this.allSequencesData.part2.length)]);
		}
		if (this.allSequencesData.part3 !== undefined && this.allSequencesData.part3.length) {
			this.sequences.push(this.allSequencesData.part3[this.random(0, this.allSequencesData.part3.length)]);
		}

		// Set the video file name 
		var i;
		for (i = 0; i < this.sequences.length; ++i) {
			var file = this.sequences[i].src;
			
			// HD
			if(this.hd) {
				file += "hd"; 
			}

			// Extention
			file += "." + this.videoExt;

			// Set the final file
			this.sequences[i].src = file;
		}
		
		this.logi("choosed sequences:");
		for (i = 0; i < this.sequences.length; ++i) {
			this.logi(this.sequenceToString(i));
		}
	};

	this.initPopSequence = function()
	{
		var self = this;

		// Create the popcorn sequencer
		self.popSeq = Popcorn.sequence(self.videoDivId, self.sequences);

		for (var i = 0; i < self.sequences.length; ++i) {
			
			var pop = self.popSeq.eq(i);

			// Hide controls
			pop.controls(false);

			// Mute (debug)
			pop.mute();

			self.listenEvent(pop, "playing", false, function() {
				self.displayPlayButton(false);
				self.logi("play sequence: " + self.sequenceToString(self.popSeq.active));
			});

			self.listenEvent(pop, "pause", false, function() {
				self.displayPlayButton(true);
				self.logi("pause sequence: " + self.sequenceToString(self.popSeq.active));
			});			

			self.listenEvent(pop, "timeupdate", false, function() {
				// Update the current time position
				$(self.progressCurrent).html(self.secondsToTime(self.popSeq.currentTime()));
			});

			self.listenEvent(pop, "canplaythrough", true, function() {
			});
		}

		self.popSeq.on("loadedmetadata", function() {

			self.playerIsReady = true;

			// Set total duration
			$(self.progressDuration).html(self.secondsToTime(self.popSeq.duration()));			

			if (!self.iOS) {
				// Automatic play
				self.ctrlPlay();

				if (self.seekTime !== 0.0) {
					self.popSeq.jumpTo(self.seekTime);
					self.seekTime = 0.0;
				}
			}

			// Unlisten event
			self.popSeq.off("loadedmetadata");

			// Call the resize object
			if (incResize !== undefined) {
				incResize.resizeElements();
			}	

			self.logi("the player is ready");
		});	

		self.popSeq.on("cycle", function() {
			self.logi("CYCLE !");
		});	
	};

	this.listenEvent = function(pop, event, unlisten, func)
	{
		pop.on(event, function() {
			// Execute the function
			func();
	
			if (unlisten) {		
				// Unlisten event
				pop.off(event);
			}
		});
	};

	this.getCurrentPop = function()
	{
		var index = this.popSeq.active;
		if (index >= this.sequences.length) {
			index = this.sequences.length-1;
		}
		return this.popSeq.eq(index);
	};

	this.ctrlPlay = function()
	{
		if (!this.iOS && !this.playerIsReady) {
			// The video are not ready
			this.logi("can't play, the player is not ready");
			return;
		}

		if (this.getCurrentPop().paused()) {
			// Play
			this.popSeq.play();
		} else {
			// Pause
			this.popSeq.pause();
		}
	};

	this.ctrlNext = function()
	{
		if (!this.playerIsReady) {
			// The video are not ready
			this.logi("can't play, the player is not ready");
			return;
		}

		if (this.popSeq.active == this.sequences.length - 1) {
			// We are at the last video
			return;
		}

		// Go to the next video
		var jumpTime = this.popSeq.durationSeqs(this.popSeq.active + 1);
		this.popSeq.jumpTo(jumpTime);
	};

	this.ctrlPrev = function()
	{
		if (!this.playerIsReady) {
			// The video are not ready
			this.logi("can't play, the player is not ready");
			return;
		}

		var videoIndex = this.popSeq.active;
		if (videoIndex !== 0) {
			// If we are a less than 1 sec from the sequence start, we just to the prev sequence
			// else we jump to the start of the current sequence
			var jumpTimeStartCurrent = this.popSeq.durationSeqs(videoIndex);
			if (this.popSeq.currentTime() - jumpTimeStartCurrent < 1) {
				--videoIndex;
			}
		}

		// Go to the next video
		var jumpTime = this.popSeq.durationSeqs(videoIndex);
		this.popSeq.jumpTo(jumpTime);
	};

	this.ctrlFullScreen = function()
	{
		if (!this.playerIsReady) {
			// The video are not ready
			this.logi("can't play, the player is not ready");
			return;
		}

		this.logi("full screen");
	};
	
	this.ctrlHd = function()
	{
		if (!this.playerIsReady) {
			// The video are not ready
			this.logi("can't play, the player is not ready");
			return;
		}

		this.seekTime = this.popSeq.currentTime();
		this.hd = false;
		this.createPopSequence();

		this.logi("hd");
	};

	this.displayPlayButton = function(playIcon)
	{
		/*
		if (playIcon) {
			// Controller display
			this.playButton.src = 'static/res/img/ctrlplayover.jpg';
	    	this.playButton.onmouseover = function() {this.src='static/res/img/ctrlplayover.jpg';}; 
	    	this.playButton.onmouseout = function() {this.src='static/res/img/ctrlplay.jpg';};
		} else {
			// Controller display
			this.playButton.src = 'static/res/img/ctrlpauseover.jpg';
	    	this.playButton.onmouseover = function() {this.src='static/res/img/ctrlpauseover.jpg';}; 
	    	this.playButton.onmouseout = function() {this.src='static/res/img/ctrlpause.jpg';};
		}
		*/
	};
		 
	// --------------------------------------------------------------------------------------------------------------------
	// Tools Functions
	// --------------------------------------------------------------------------------------------------------------------

	this.logi = function(txt)
	{
		if (this.logiEnable) {
			console.log("info: " + txt);
		}
	};

	this.loge = function(txt)
	{
		console.log("error: " + txt);
	};

	this.loadJson = function(jsonFile)
	{
		var txt = this.loadTxtFile(jsonFile);
		return JSON.parse(txt);
	};

	this.loadTxtFile = function(jsonFile)
	{
		var xhr = new XMLHttpRequest();
		xhr.open("GET", jsonFile, false);  
		xhr.overrideMimeType('text/plain; charset=x-user-defined');

		try {
			xhr.send(null); 
		} catch(e) {
			return "";
		}

		if (xhr.status == 404) {
			return "";
		}
		
		var buffer;
		if (xhr.responseType == "arraybuffer") {
			buffer = xhr.response;
		} else if (xhr.mozResponseArrayBuffer === null) {
			buffer = xhr.mozResponseArrayBuffer;  
		} else {
			buffer = xhr.response;
		}
		return buffer;
	};

	this.random = function(min, max)
	{
		return Math.floor((Math.random()*(max-min))+min);
	};

	this.secondsToTime = function(sec)
	{
		var minutes = Math.floor(sec / 60);
		var seconds = Math.floor(sec - minutes * 60);
		if (seconds < 10) {
			seconds = "0" + seconds;
		}
		return "" + minutes + "'" + seconds + "''";
	};

	this.sequenceToString = function(index)
	{
		return JSON.stringify(this.sequences[index]);
	};

	this.getSupportedVideoExt = function()
	{
		var v = document.createElement("video");

		if (v.canPlayType) {

		    // Check for Ogg support
		    if (this.preferOgg && v.canPlayType('video/ogg; codecs="theora"') !== "") {
		    	return "ogg";
		    }
		    
		    // Check for Webm support
		    if (v.canPlayType('video/webm; codecs="vp8, vorbis"') !== "") {
		    	return "webm";
		    }

		    // Check for MPEG-4 support
		    if (v.canPlayType('video/mp4; codecs="mp4v.20.8"' ) !== "") {
				return "mp4";
		    }

		    // Check for h264 support
		    if ((v.canPlayType('video/mp4; codecs="avc1.42E01E"' ) !== "" || v.canPlayType('video/mp4; codecs="avc1.42E01E, mp4a.40.2"'))) {
		    	return "mp4";
		    }
		}

		return "";
	};

	this.detectIOS = function()
	{
		var p = navigator.platform;
		if (p === 'iPad' || p === 'iPhone' || p === 'iPod') {
		    this.iOS = true;
		}		
	};
}

var incPlayer = new IncPlayer();
