function IncMosaic()
{
	// --------------------------------------------------------------------------------------------------------------------
	// Members
	// --------------------------------------------------------------------------------------------------------------------
	
	// Canvas
	this.canvas;
	this.context;

	/// Images
	this.pairUrl = [];
	this.pairImages = [];
	this.imagesLoaded = 0;

	// Effect
	this.countX;
	this.countY;
	this.squareX;
	this.squareY;
	this.effects = [];
	this.squareEffects = [];

	this.noEffectinfo = new IncEffectInfo();
	this.noEffectinfo.color = new IncColor(255, 255, 255, 1)
	this.noEffectinfo.alpha = 1;

	// Debug
	this.lastTime;

	// --------------------------------------------------------------------------------------------------------------------
	// Functions
	// --------------------------------------------------------------------------------------------------------------------

	this.addPairImages = function(url1, url2)
	{
		var urls = new IncPairUrl(url1, url2);
		this.pairUrl.push(urls);
	};

	this.start = function(canvasId, countX, countY)
	{
		// Init the canvas objects
		this.init(canvasId);

		// Register effects
		this.registerEffects();

		// Count, square`
		this.countX = countX;
		this.countY = (countY === undefined) ? countX: countY;
		this.squareX = Math.floor(this.canvas.width / this.countX);
		this.squareY = Math.floor(this.canvas.height / this.countY);

		// Set a random pair images
		this.setRandomPairImages();

		// Set random effect on the squares
		this.setRandomSquareEffect();
										
		// Main loop
		this.loopCallback2();
	};

	this.init = function(canvasId)
	{
		// Init canvas objects
		this.canvas = document.getElementById(canvasId);
		this.ctx = this.canvas.getContext('2d');
		this.ctx.fillStyle = "#000000";
		this.ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
	};

	this.registerEffects = function()
	{
		// No effect 
		//-----------------------------------
		var noEffect = new IncSquareEffect_NoEffet()
		var fullEffect0 = new IncFullEffect(noEffect);
		//this.effects.push(fullEffect0);

		// Alpha 
		//-----------------------------------
		{
			var effectParam1 = new IncEffectParams(new IncColor(255, 255, 255, 0), new IncAnim(1, 5000), 1, new IncAnim(-1, 5000), 5000);
			var effect1 = new IncSquareEffect_Alpha(effectParam1, createjs.Ease.quadInOut, createjs.Ease.quadInOut);

			var effectParam2 = new IncEffectParams(new IncColor(255, 255, 255, 1), new IncAnim(0, 5000), 0, new IncAnim(1, 7000), 8000);
			var effect2 = new IncSquareEffect_Alpha(effectParam2, createjs.Ease.quadInOut, createjs.Ease.quadInOut, 5000);

			this.effects.push(new IncFullEffect(effect1, effect2));			
		}
	}

	this.setRandomPairImages = function()
	{
		this.imagesLoaded = 0;
		var randInd = this.randomInt(0, this.pairUrl.length);
		var pairUrl = this.pairUrl[randInd];
		this.pairImages.push(this.getImageFromUrl(pairUrl.imageUrl1));
		this.pairImages.push(this.getImageFromUrl(pairUrl.imageUrl2));
	};

	this.setRandomSquareEffect = function()
	{
		/*
		for (var i = 0; i < this.countX; ++i) {
			for (var j = 0; j < this.countY; ++j) {
				//var fullEffect = this.effects[this.randomInt(0, this.effects.length)].copy();
				var fullEffect = this.effects[0].copy();
				fullEffect.x = i;
				fullEffect.y = j;
				this.squareEffects.push(fullEffect);				
			}			
		}*/
		{
			var e1 = this.effects[0].copy();
			e1.x = 2;
			e1.y = 1;
			this.squareEffects.push(e1);
		}
		/*
		{
			var e1 = this.effects[1].copy();
			e1.x = 3;
			e1.y = 0;
			this.squareEffects.push(e1);
		}
		{
			var e1 = this.effects[2].copy();
			e1.x = 2;
			e1.y = 1;
			this.squareEffects.push(e1);
		}
		*/
	};	
		
	this.loopCallback = function()
	{
		var self = incMosaic;

		if (self.imagesLoaded != 2) {
			// Images are not loaded yet
			requestAnimationFrame(self.loopCallback);
			return;
		}

		// Clear canvas
		self.ctx.fillStyle = "#ffffff";
		self.ctx.fillStyle = "#000000";
		self.ctx.fillRect(0, 0, self.canvas.width, self.canvas.height);	

		// Get time
		var time = new Date().getTime();

		// Update effect
		for (var i = 0; i < self.squareEffects.length; ++i) {
			var fullEffect = self.squareEffects[i];

			for (var j = 0; j < 2; ++j) {
				var effect = fullEffect.effects[j];
				if (effect !== undefined) {
					// Draw square
					self.drawSquare(fullEffect, self.pairImages[j], effect, time);
				}
			}
		}

		//console.log(time - this.lastTime);
		this.lastTime = time;

		// Loop
		requestAnimationFrame(self.loopCallback);
	};

	this.loopCallback2 = function()
	{
		var self = incMosaic;

		if (self.imagesLoaded != 2) {
			// Images are not loaded yet
			requestAnimationFrame(self.loopCallback2);
			return;
		}

		// Clear canvas
		self.ctx.fillStyle = "#ffffff";
		self.ctx.fillStyle = "#000000";
		self.ctx.fillRect(0, 0, self.canvas.width, self.canvas.height);	

		// Get time
		var time = new Date().getTime();

		// Update effect
		for (var i = 0; i < self.squareEffects.length; ++i) {
			// Draw square
			var fullEffect = self.squareEffects[i];
			self.drawSquare2(fullEffect, time);
		}

		//console.log(time - this.lastTime);
		this.lastTime = time;

		// Loop
		requestAnimationFrame(self.loopCallback2);
	};

	this.drawSquare = function(fullEffect, image, effect, time)
	{
		// Update effect
		var effectInfo = effect.update(fullEffect, time);

		if (effectInfo === null) {
			return;
		}

		// Compute square position
		var posX = fullEffect.x * this.squareX;
		var posY = fullEffect.y * this.squareY;

		this.ctx.save();

		// Global alpha
		this.ctx.globalAlpha = effectInfo.alpha;	

		// Draw colored rectangle
		this.ctx.fillStyle = "rgba(" + effectInfo.color.r + "," + effectInfo.color.v + "," + effectInfo.color.b + "," + effectInfo.color.a + ")";
		this.ctx.fillRect(posX, posY, this.squareX, this.squareY);

		// Draw image
		this.ctx.drawImage(image, posX, posY, this.squareX, this.squareY, posX, posY, this.squareX, this.squareY);

		this.ctx.restore();
	};

	this.drawSquare2 = function(fullEffect, time)
	{
		// Update effect
		var effectInfo1 = fullEffect.effects[0].update(fullEffect, time);
		var effectInfo2 = (fullEffect.effects[1] !== undefined) ? fullEffect.effects[1].update(fullEffect, time) : null;

		// Compute square position
		var posX = fullEffect.x * this.squareX;
		var posY = fullEffect.y * this.squareY;

		this.ctx.save();

		if (effectInfo1 !== null) {
			this.ctx.globalAlpha = effectInfo1.alpha;				
			this.ctx.drawImage(this.pairImages[0], posX, posY, this.squareX, this.squareY, posX, posY, this.squareX, this.squareY);

			if (effectInfo2 !== null) {
				var image1 = this.ctx.getImageData(posX, posY, this.squareX, this.squareY);
				var imageData1 = image1.data;

				this.ctx.globalAlpha = effectInfo2.alpha;	
				this.ctx.drawImage(this.pairImages[1], posX, posY, this.squareX, this.squareY, posX, posY, this.squareX, this.squareY);
				var image2 = this.ctx.getImageData(posX, posY, this.squareX, this.squareY);
				var imageData2 = image2.data;

				var pixels = 4 * this.squareX * this.squareY;
				while (pixels--) {
				    imageData1[pixels] = imageData1[pixels] * 0.5 + imageData2[pixels] * 0.5;
				    //imageData1[pixels] = imageData1[pixels] * effectInfo1.alpha + imageData2[pixels] * effectInfo1.alpha;;
				}

				this.ctx.putImageData(image1, posX, posY);
			}


		} else if (effectInfo2 !== null) {
			console.log(effectInfo2.alpha);
			this.ctx.globalAlpha = effectInfo2.alpha;
			this.ctx.drawImage(this.pairImages[1], posX, posY, this.squareX, this.squareY, posX, posY, this.squareX, this.squareY);
		}

		this.ctx.restore();
	};

	// --------------------------------------------------------------------------------------------------------------------
	// Tools
	// --------------------------------------------------------------------------------------------------------------------

	this.randomInt = function(min, max)
	{
		return Math.floor(this.randomFloat(min, max));
	};

	this.randomFloat = function(min, max)
	{
		return Math.random() * (max - min) + min;
	};

	this.getImageFromUrl = function(url)
	{
		var image = new Image();
		image.onload = function() {
			incMosaic.imagesLoaded += 1;
		};
		image.src = url;
		return image;
	};
}

function IncPairUrl(url1, url2)
{
	this.imageUrl1 = url1;
	this.imageUrl2 = url2;
}

// --------------------------------------------------------------------------------------------------------------------
// Effects
// --------------------------------------------------------------------------------------------------------------------

function IncColor(r, v, b, a)
{
	this.r = r;
	this.v = v;
	this.b = b;
	this.a = a;

	this.copy = function()
	{
		return new IncColor(this.r, this.v, this.b, this.a);
	};
}

function IncAnim(value, time)
{
	this.value = value;
	this.time = time;
}

function IncEffectInfo()
{
	this.color;
	this.alpha;
}

function IncEffectParams(color, colorAnim, alpha, alphaAnim, time)
{
	// Color
	this.color = color;
	this.colorAnim = colorAnim;

	// Alpha
	this.alpha = alpha;
	this.alphaAnim = alphaAnim;

	// Time
	this.time = time;

	this.computeColorAnimValue = function(elapsedTime, easeFunc)
	{
		return this.computeAnimValue(this.colorAnim, elapsedTime, easeFunc);
	};

	this.computeAlphaAnimValue = function(elapsedTime, easeFunc)
	{
		return this.computeAnimValue(this.alphaAnim, elapsedTime, easeFunc);
	};

	this.computeAnimValue = function(anim, elapsedTime, easeFunc)
	{
		// Compute color alpha anim
		if (elapsedTime < anim.time) {
			return easeFunc(elapsedTime/anim.time) * anim.value;			
		}
		return anim.value;
	};	
}

function IncSquareEffect_NoEffet()
{
	this.update = function(fullEffect, time)
	{
		return incMosaic.noEffectinfo;
	}
}

function IncSquareEffect_Alpha(effectParms, tweenColorFunc, tweenAlphaFunc, waitTime)
{
	// Effect parameters
	this.effectParms = effectParms;

	// Tween functions
	this.tweenColorFunc = tweenColorFunc;
	this.tweenAlphaFunc = tweenAlphaFunc;

	// Time
	this.waitTime = (waitTime!==undefined) ? (new Date().getTime() + waitTime) : 0; 

	this.update = function(fullEffect, time)
	{
		if (this.waitTime > time) {
			return null;
		}

		if (fullEffect.startTime == 0) {
			fullEffect.startTime = time;			
		}

		if ((time - fullEffect.startTime) > this.effectParms.time) {
			return null;
		}

		var elapsedTime = this.waitTime ? (time - fullEffect.waitTime) : (time - fullEffect.startTime);
		console.log(elapsedTime);
		var info = new IncEffectInfo();

		// Compute new color
		var newColorValue = this.effectParms.computeColorAnimValue(elapsedTime, this.tweenColorFunc);
		info.color = this.effectParms.color.copy();
		info.color.a += newColorValue;

		// Compute alpha anim
		var newAlphaValue = this.effectParms.computeAlphaAnimValue(elapsedTime, this.tweenAlphaFunc);
		info.alpha = this.effectParms.alpha;
		info.alpha += newAlphaValue;

		return info;
	};
}

function IncFullEffect(effect1, effect2)
{
	// Position
	this.x = 0;
	this.y = 0;

	// Effect	
	this.effects = [effect1, effect2];

	// Time
	this.startTime = 0;	

	this.copy = function()
	{
		return new IncFullEffect(this.effects[0], this.effects[1]);
	};	
}

// --------------------------------------------------------------------------------------------------------------------
// Tools
// --------------------------------------------------------------------------------------------------------------------

window.requestAnimationFrame = (function() {              
	return window.requestAnimationFrame    ||  	// Chromium 
		window.webkitRequestAnimationFrame ||  	// Webkit
		window.mozRequestAnimationFrame    || 	// Mozilla Geko
		window.oRequestAnimationFrame      || 	// Opera Presto
		window.msRequestAnimationFrame     || 	// IE Trident?
		function(callback, element){ 			// Fallback function
		   window.setTimeout(callback, 20);                
		};    
})();

var incMosaic = new IncMosaic();

