var effectSpeed = 8;

function IncChoice()
{
	this.currentWorldIndex = 0;
	this.canSelectWord = true;
	this.image1;
	this.image2;
	this.image3;

	this.setMosaicImages = function(images1, images2, images3)
	{
		// Choose 2 image for the effect
		this.image1 = images1[incMosaic.randomInt(0, images1.length)];
		this.image2 = images2[incMosaic.randomInt(0, images2.length)];
		this.image3 = images3[incMosaic.randomInt(0, images3.length)];

	    incMosaic.addImageUrl("static/res/img/" + this.image1);
	    incMosaic.addImageUrl("static/res/img/" + this.image2);
	    incMosaic.addImageUrl("static/res/img/" + this.image3);

	    incMosaic.start("mosaic", effectSpeed, 9, 5, true, true, function() {incChoice.effectIsDone();});		
	};

	this.setWordsAndEffect = function(choiceIndex)
	{
		if (choiceIndex == 0) {
			$("#mot1").html("famille");
			$("#mot2").html("amour");
			$("#mot3").html("travail");
			$("#mot4").html("international");
			$("#mot5").html("dieu");
			$("#mot6").html("president");

			// class
			// by default there is the calss blue

		} else if (choiceIndex == 1) {
			$("#mot1").html("actif");
			$("#mot2").html("passif");
			$("#mot3").html("corps");
			$("#mot4").html("charite");
			$("#mot5").html("patrie");
			$("#mot6").html("politique");

			// class
			$("#choix").removeClass("blue").addClass("white");

		} else {
			$("#mot1").html("spleen");
			$("#mot2").html("ideal");
			$("#mot3").html("origines");
			$("#mot4").html("peur");
			$("#mot5").html("desir");
			$("#mot6").html("bonheur");

			// class
			$("#choix").removeClass("white").addClass("red");
		}
	};

	this.selectWord = function(wordIndex)
	{
		if (!this.canSelectWord) {
			// Don't set the word 2 times
			return;
		}

		this.canSelectWord = false;

		// Save the word
		this.setCookie("niv1_world" + this.currentWorldIndex, $("#mot" + wordIndex).html());

		++this.currentWorldIndex;

		if (this.currentWorldIndex == 3) {
			// The 3 words get choosen
			location.href = "niv1_videoplayer.html";
		} else {
			
			// Start the mosaic effect
			incMosaic.UnpauseEffect(true);

			// Fade the text
			$('.big_txt').animate({opacity: 0}, 20000 * 1 / effectSpeed);
		}
	};

	this.effectIsDone = function()
	{
		this.canSelectWord = true;

        // Set the list of words and the mosaic effect
		this.setWordsAndEffect(this.currentWorldIndex);

		// Stop the mosaic effect
		incMosaic.UnpauseEffect(false);

		// Fade the text
		$('.big_txt').animate({opacity: 1}, 10000 * 1 / effectSpeed);
	};

	this.getChoosenWords = function()
	{
		return [this.getCookie("niv1_world0"), this.getCookie("niv1_world1"), this.getCookie("niv1_world2")];
	};

	this.setCookie = function(name, value)
	{
		$.removeCookie(name);
		$.cookie(name, value, { expires: 7, path: '/' }); 
    };

	this.getCookie = function(name) {
		return $.cookie(name);
	};
}

var incChoice = new IncChoice();